"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isApiCompatible = exports.filterByMapExtentAction = exports.FILTER_BY_MAP_EXTENT = void 0;
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _constants = require("../../../common/constants");
var _is_legacy_map = require("../../legacy_visualizations/is_legacy_map");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FILTER_BY_MAP_EXTENT = exports.FILTER_BY_MAP_EXTENT = 'FILTER_BY_MAP_EXTENT';
const isApiCompatible = api => Boolean((0, _presentationPublishing.apiHasType)(api));
exports.isApiCompatible = isApiCompatible;
function getContainerLabel(api) {
  var _api$parentApi;
  return isApiCompatible(api) && ((_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : _api$parentApi.type) === 'dashboard' ? _i18n.i18n.translate('xpack.maps.filterByMapExtentMenuItem.dashboardLabel', {
    defaultMessage: 'dashboard'
  }) : _i18n.i18n.translate('xpack.maps.filterByMapExtentMenuItem.pageLabel', {
    defaultMessage: 'page'
  });
}
function getDisplayName(api) {
  return _i18n.i18n.translate('xpack.maps.filterByMapExtentMenuItem.displayName', {
    defaultMessage: 'Filter {containerLabel} by map bounds',
    values: {
      containerLabel: getContainerLabel(api)
    }
  });
}
const filterByMapExtentAction = exports.filterByMapExtentAction = (0, _public.createAction)({
  id: FILTER_BY_MAP_EXTENT,
  type: FILTER_BY_MAP_EXTENT,
  order: 20,
  getDisplayName: ({
    embeddable
  }) => {
    return getDisplayName(embeddable);
  },
  getDisplayNameTooltip: ({
    embeddable
  }) => {
    return _i18n.i18n.translate('xpack.maps.filterByMapExtentMenuItem.displayNameTooltip', {
      defaultMessage: 'As you zoom and pan the map, the {containerLabel} updates to display only the data visible in the map bounds.',
      values: {
        containerLabel: getContainerLabel(embeddable)
      }
    });
  },
  getIconType: () => {
    return 'filter';
  },
  isCompatible: async ({
    embeddable
  }) => {
    if (!isApiCompatible(embeddable) || embeddable.disableTriggers) return false;
    return (0, _presentationPublishing.apiIsOfType)(embeddable, _constants.MAP_SAVED_OBJECT_TYPE) || (0, _public2.apiHasVisualizeConfig)(embeddable) && (0, _is_legacy_map.isLegacyMapApi)(embeddable);
  },
  execute: async ({
    embeddable
  }) => {
    const {
      openModal
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./modal')));
    openModal(getDisplayName(embeddable));
  }
});