"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PassiveMap = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _common = require("../../common");
var _create_basemap_layer_descriptor = require("../classes/layers/create_basemap_layer_descriptor");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * PassiveMap compoment is a wrapper around a map embeddable where passive layer descriptor provides features
 * and layer does not auto-fetch features based on changes to pan, zoom, filter, query, timeRange, and other state changes.
 * To update features, update passiveLayer prop with new layer descriptor.
 * Contrast with traditional map (active map), where layers independently auto-fetch features
 * based on changes to pan, zoom, filter, query, timeRange, and other state changes
 */
class PassiveMap extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_prevPassiveLayer", this.props.passiveLayer);
    (0, _defineProperty2.default)(this, "_embeddableRef", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)(this, "_onRenderSubscription", void 0);
    (0, _defineProperty2.default)(this, "state", {
      mapEmbeddable: null
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._setupEmbeddable();
  }
  componentWillUnmount() {
    this._isMounted = false;
    if (this.state.mapEmbeddable) {
      this.state.mapEmbeddable.destroy();
    }
    if (this._onRenderSubscription) {
      this._onRenderSubscription.unsubscribe();
    }
  }
  componentDidUpdate() {
    if (this.state.mapEmbeddable && this._prevPassiveLayer !== this.props.passiveLayer) {
      this.state.mapEmbeddable.updateLayerById(this.props.passiveLayer);
      this._prevPassiveLayer = this.props.passiveLayer;
    }
  }
  async _setupEmbeddable() {
    const basemapLayerDescriptor = (0, _create_basemap_layer_descriptor.createBasemapLayerDescriptor)();
    const intialLayers = basemapLayerDescriptor ? [basemapLayerDescriptor] : [];
    const mapEmbeddable = await this.props.factory.create({
      id: (0, _uuid.v4)(),
      attributes: {
        title: '',
        layerListJSON: JSON.stringify([...intialLayers, this.props.passiveLayer])
      },
      filters: [],
      hidePanelTitles: true,
      viewMode: _public.ViewMode.VIEW,
      isLayerTOCOpen: false,
      hideFilterActions: true,
      mapSettings: {
        disableInteractive: false,
        hideToolbarOverlay: false,
        hideLayerControl: false,
        hideViewControl: false,
        initialLocation: _common.INITIAL_LOCATION.AUTO_FIT_TO_BOUNDS,
        // this will startup based on data-extent
        autoFitToDataBounds: true // this will auto-fit when there are changes to the filter and/or query
      }
    });
    if (!mapEmbeddable) {
      return;
    }
    this._onRenderSubscription = mapEmbeddable.getOnRenderComplete$().subscribe(() => {
      if (this._isMounted) {
        this.props.onRenderComplete();
      }
    });
    if (this._isMounted) {
      mapEmbeddable.setIsSharable(false);
      this.setState({
        mapEmbeddable
      }, () => {
        if (this.state.mapEmbeddable && this._embeddableRef.current) {
          this.state.mapEmbeddable.render(this._embeddableRef.current);
        }
      });
    }
  }
  render() {
    if (!this.state.mapEmbeddable) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
        mono: true,
        size: "l"
      });
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "mapEmbeddableContainer",
      ref: this._embeddableRef
    });
  }
}
exports.PassiveMap = PassiveMap;