"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupLensChoroplethChart = setupLensChoroplethChart;
var _expression_function = require("./expression_function");
var _expression_renderer = require("./expression_renderer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function setupLensChoroplethChart(coreSetup, expressions, lens) {
  expressions.registerRenderer(() => {
    return (0, _expression_renderer.getExpressionRenderer)(coreSetup);
  });
  expressions.registerFunction(_expression_function.getExpressionFunction);
  lens.registerVisualization(async () => {
    const [coreStart, plugins] = await coreSetup.getStartServices();
    const {
      getEmsFileLayers
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../util')));
    const {
      getVisualization
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./visualization')));
    let emsFileLayers = [];
    try {
      emsFileLayers = await getEmsFileLayers();
    } catch (error) {
      // eslint-disable-next-line no-console
      console.warn(`Lens region map setup is unable to access administrative boundaries from Elastic Maps Service (EMS). To avoid unnecessary EMS requests, set 'map.includeElasticMapsService: false' in 'kibana.yml'. For more details please visit ${coreStart.docLinks.links.maps.connectToEms}`);
    }
    return getVisualization({
      theme: coreStart.theme,
      emsFileLayers,
      paletteService: await plugins.charts.palettes.getPalettes()
    });
  });
}