"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tileMapRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _lazy_wrapper = require("../../lazy_wrapper");
var _types = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getLazyComponent = () => {
  return /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./tile_map_visualization'))));
};
const tileMapRenderer = exports.tileMapRenderer = {
  name: _types.TILE_MAP_RENDER,
  reuseDomNode: true,
  render: async (domNode, {
    filters,
    query,
    timeRange,
    visConfig
  }, handlers) => {
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const props = {
      onInitialRenderComplete: () => {
        handlers.done();
      },
      filters,
      query,
      timeRange,
      visConfig
    };
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_lazy_wrapper.LazyWrapper, {
      getLazyComponent: getLazyComponent,
      lazyComponentProps: props
    }), domNode);
  }
};