"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isScreenshotMode = exports.getVisualizeCapabilities = exports.getUsageCollection = exports.getUrlForApp = exports.getUiSettings = exports.getUiActions = exports.getToasts = exports.getTimeFilter = exports.getTheme = exports.getSpacesApi = exports.getSpaceId = exports.getShowMapsInspectorAdapter = exports.getShareService = exports.getServerless = exports.getSecurityService = exports.getSearchService = exports.getSearchBar = exports.getSavedObjectsTagging = exports.getPreserveDrawingBuffer = exports.getPresentationUtilContext = exports.getNavigation = exports.getNavigateToUrl = exports.getNavigateToApp = exports.getMapsEmsStart = exports.getMapsCapabilities = exports.getMapAppConfig = exports.getIsDarkMode = exports.getIsCloud = exports.getIsAllowByValueEmbeddables = exports.getInspector = exports.getIndexPatternService = exports.getIndexPatternSelectComponent = exports.getIndexNameFormComponent = exports.getHttp = exports.getFileUploadComponent = exports.getFileUpload = exports.getExecutionContextService = exports.getEmsTileLayerId = exports.getEmbeddableService = exports.getEMSSettings = exports.getDocLinks = exports.getDevToolsCapabilities = exports.getData = exports.getCoreOverlays = exports.getCoreI18n = exports.getCoreChrome = exports.getCore = exports.getContentManagement = exports.getCharts = exports.getAutocompleteService = exports.getApplication = void 0;
exports.setIsCloudEnabled = setIsCloudEnabled;
exports.setSpaceId = exports.setMapAppConfig = void 0;
exports.setStartServices = setStartServices;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let isDarkMode = false;
let coreStart;
let pluginsStart;
let mapsEms;
let emsSettings;
function setStartServices(core, plugins) {
  coreStart = core;
  pluginsStart = plugins;
  mapsEms = plugins.mapsEms;
  emsSettings = mapsEms.createEMSSettings();
  core.theme.theme$.subscribe(({
    darkMode
  }) => {
    isDarkMode = darkMode;
  });
}
let isCloudEnabled = false;
function setIsCloudEnabled(enabled) {
  isCloudEnabled = enabled;
}
const getIsCloud = () => isCloudEnabled;
exports.getIsCloud = getIsCloud;
let spaceId = 'default';
const getSpaceId = () => spaceId;
exports.getSpaceId = getSpaceId;
const setSpaceId = _spaceId => {
  spaceId = _spaceId;
};
exports.setSpaceId = setSpaceId;
const getIndexNameFormComponent = () => pluginsStart.fileUpload.IndexNameFormComponent;
exports.getIndexNameFormComponent = getIndexNameFormComponent;
const getFileUploadComponent = () => pluginsStart.fileUpload.FileUploadComponent;
exports.getFileUploadComponent = getFileUploadComponent;
const getIndexPatternService = () => pluginsStart.data.dataViews;
exports.getIndexPatternService = getIndexPatternService;
const getAutocompleteService = () => pluginsStart.unifiedSearch.autocomplete;
exports.getAutocompleteService = getAutocompleteService;
const getInspector = () => pluginsStart.inspector;
exports.getInspector = getInspector;
const getFileUpload = () => pluginsStart.fileUpload;
exports.getFileUpload = getFileUpload;
const getUiSettings = () => coreStart.uiSettings;
exports.getUiSettings = getUiSettings;
const getIsDarkMode = () => isDarkMode;
exports.getIsDarkMode = getIsDarkMode;
const getIndexPatternSelectComponent = () => pluginsStart.unifiedSearch.ui.IndexPatternSelect;
exports.getIndexPatternSelectComponent = getIndexPatternSelectComponent;
const getSearchBar = () => pluginsStart.unifiedSearch.ui.SearchBar;
exports.getSearchBar = getSearchBar;
const getHttp = () => coreStart.http;
exports.getHttp = getHttp;
const getExecutionContextService = () => coreStart.executionContext;
exports.getExecutionContextService = getExecutionContextService;
const getTimeFilter = () => pluginsStart.data.query.timefilter.timefilter;
exports.getTimeFilter = getTimeFilter;
const getToasts = () => coreStart.notifications.toasts;
exports.getToasts = getToasts;
const getCoreChrome = () => coreStart.chrome;
exports.getCoreChrome = getCoreChrome;
const getDevToolsCapabilities = () => coreStart.application.capabilities.dev_tools;
exports.getDevToolsCapabilities = getDevToolsCapabilities;
const getMapsCapabilities = () => coreStart.application.capabilities.maps;
exports.getMapsCapabilities = getMapsCapabilities;
const getVisualizeCapabilities = () => coreStart.application.capabilities.visualize;
exports.getVisualizeCapabilities = getVisualizeCapabilities;
const getDocLinks = () => coreStart.docLinks;
exports.getDocLinks = getDocLinks;
const getCoreOverlays = () => coreStart.overlays;
exports.getCoreOverlays = getCoreOverlays;
const getCharts = () => pluginsStart.charts;
exports.getCharts = getCharts;
const getData = () => pluginsStart.data;
exports.getData = getData;
const getUiActions = () => pluginsStart.uiActions;
exports.getUiActions = getUiActions;
const getCore = () => coreStart;
exports.getCore = getCore;
const getNavigation = () => pluginsStart.navigation;
exports.getNavigation = getNavigation;
const getCoreI18n = () => coreStart.i18n;
exports.getCoreI18n = getCoreI18n;
const getSearchService = () => pluginsStart.data.search;
exports.getSearchService = getSearchService;
const getEmbeddableService = () => pluginsStart.embeddable;
exports.getEmbeddableService = getEmbeddableService;
const getNavigateToApp = () => coreStart.application.navigateToApp;
exports.getNavigateToApp = getNavigateToApp;
const getUrlForApp = () => coreStart.application.getUrlForApp;
exports.getUrlForApp = getUrlForApp;
const getNavigateToUrl = () => coreStart.application.navigateToUrl;
exports.getNavigateToUrl = getNavigateToUrl;
const getSavedObjectsTagging = () => pluginsStart.savedObjectsTagging;
exports.getSavedObjectsTagging = getSavedObjectsTagging;
const getPresentationUtilContext = () => pluginsStart.presentationUtil.ContextProvider;
exports.getPresentationUtilContext = getPresentationUtilContext;
const getSecurityService = () => pluginsStart.security;
exports.getSecurityService = getSecurityService;
const getSpacesApi = () => pluginsStart.spaces;
exports.getSpacesApi = getSpacesApi;
const getTheme = () => coreStart.theme;
exports.getTheme = getTheme;
const getApplication = () => coreStart.application;
exports.getApplication = getApplication;
const getUsageCollection = () => pluginsStart.usageCollection;
exports.getUsageCollection = getUsageCollection;
const getContentManagement = () => pluginsStart.contentManagement;
exports.getContentManagement = getContentManagement;
const isScreenshotMode = () => {
  return pluginsStart.screenshotMode ? pluginsStart.screenshotMode.isScreenshotMode() : false;
};
exports.isScreenshotMode = isScreenshotMode;
const getServerless = () => pluginsStart.serverless;

// xpack.maps.* kibana.yml settings from this plugin
exports.getServerless = getServerless;
let mapAppConfig;
const setMapAppConfig = config => mapAppConfig = config;
exports.setMapAppConfig = setMapAppConfig;
const getMapAppConfig = () => mapAppConfig;
exports.getMapAppConfig = getMapAppConfig;
const getShowMapsInspectorAdapter = () => getMapAppConfig().showMapsInspectorAdapter;
exports.getShowMapsInspectorAdapter = getShowMapsInspectorAdapter;
const getPreserveDrawingBuffer = () => getMapAppConfig().preserveDrawingBuffer;
exports.getPreserveDrawingBuffer = getPreserveDrawingBuffer;
const getMapsEmsStart = () => {
  return mapsEms;
};
exports.getMapsEmsStart = getMapsEmsStart;
const getEMSSettings = () => {
  return emsSettings;
};
exports.getEMSSettings = getEMSSettings;
const getEmsTileLayerId = () => mapsEms.config.emsTileLayerId;
exports.getEmsTileLayerId = getEmsTileLayerId;
const getShareService = () => pluginsStart.share;
exports.getShareService = getShareService;
const getIsAllowByValueEmbeddables = () => pluginsStart.dashboard.dashboardFeatureFlagConfig.allowByValueEmbeddables;
exports.getIsAllowByValueEmbeddables = getIsAllowByValueEmbeddables;