"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapInspectorView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lazy_wrapper = require("../../lazy_wrapper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getLazyComponent = () => {
  return /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./map_view_component'))));
};
const MapInspectorView = exports.MapInspectorView = {
  title: _i18n.i18n.translate('xpack.maps.inspector.mapDetailsViewTitle', {
    defaultMessage: 'Map details'
  }),
  order: 30,
  help: _i18n.i18n.translate('xpack.maps.inspector.mapDetailsViewHelpText', {
    defaultMessage: 'View the map state'
  }),
  shouldShow(adapters) {
    return Boolean(adapters.map);
  },
  component: props => {
    return /*#__PURE__*/_react.default.createElement(_lazy_wrapper.LazyWrapper, {
      getLazyComponent: getLazyComponent,
      lazyComponentProps: props
    });
  }
};