"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _embeddable = require("../../common/embeddable");
var _kibana_services = require("../kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class MapEmbeddableFactory {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _constants.MAP_SAVED_OBJECT_TYPE);
    (0, _defineProperty2.default)(this, "savedObjectMetaData", {
      name: _i18n.i18n.translate('xpack.maps.mapSavedObjectLabel', {
        defaultMessage: 'Map'
      }),
      type: _constants.MAP_SAVED_OBJECT_TYPE,
      getIconForSavedObject: () => _constants.APP_ICON
    });
    (0, _defineProperty2.default)(this, "createFromSavedObject", async (savedObjectId, input, parent) => {
      if (!input.savedObjectId) {
        input.savedObjectId = savedObjectId;
      }
      return this.create(input, parent);
    });
    (0, _defineProperty2.default)(this, "create", async (input, parent) => {
      const {
        MapEmbeddable
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./map_embeddable')));
      const usageCollection = (0, _kibana_services.getUsageCollection)();
      if (usageCollection) {
        // currentAppId$ is a BehaviorSubject exposed as an observable so subscription gets last value upon subscribe
        (0, _kibana_services.getApplication)().currentAppId$.pipe((0, _rxjs.first)()).subscribe(appId => {
          if (appId) usageCollection.reportUiCounter('map', 'loaded', `open_maps_vis_${appId}`);
        });
      }
      return new MapEmbeddable({
        editable: await this.isEditable()
      }, input, parent);
    });
    (0, _defineProperty2.default)(this, "inject", _embeddable.inject);
    (0, _defineProperty2.default)(this, "extract", _embeddable.extract);
  }
  async isEditable() {
    return (0, _kibana_services.getMapsCapabilities)().save;
  }

  // Not supported yet for maps types.
  canCreateNew() {
    return false;
  }
  getDisplayName() {
    return _constants.MAP_EMBEDDABLE_NAME;
  }
}
exports.MapEmbeddableFactory = MapEmbeddableFactory;