"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapComponent = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _map_embeddable = require("./map_embeddable");
var _create_basemap_layer_descriptor = require("../classes/layers/create_basemap_layer_descriptor");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MapComponent extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_mapEmbeddable", void 0);
    (0, _defineProperty2.default)(this, "_embeddableRef", /*#__PURE__*/_react.default.createRef());
    this._mapEmbeddable = new _map_embeddable.MapEmbeddable({
      editable: false
    }, {
      id: (0, _uuid.v4)(),
      attributes: {
        title: this.props.title,
        layerListJSON: JSON.stringify([(0, _create_basemap_layer_descriptor.createBasemapLayerDescriptor)(), ...this.props.getLayerDescriptors()])
      },
      mapCenter: this.props.mapCenter
    });
    if (this.props.onInitialRenderComplete) {
      this._mapEmbeddable.getOnRenderComplete$().pipe((0, _rxjs.first)()).subscribe(() => {
        if (this.props.onInitialRenderComplete) {
          this.props.onInitialRenderComplete();
        }
      });
    }
    if (this.props.isSharable !== undefined) {
      this._mapEmbeddable.setIsSharable(this.props.isSharable);
    }
  }
  componentDidMount() {
    if (this._embeddableRef.current) {
      this._mapEmbeddable.render(this._embeddableRef.current);
    }
  }
  componentWillUnmount() {
    this._mapEmbeddable.destroy();
  }
  componentDidUpdate() {
    this._mapEmbeddable.updateInput({
      filters: this.props.filters,
      query: this.props.query,
      timeRange: this.props.timeRange
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "mapEmbeddableContainer",
      ref: this._embeddableRef
    });
  }
}
exports.MapComponent = MapComponent;