"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Timeslider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/controls-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Timeslider extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_subscriptions", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "_getCreationOptions", async (initialInput, builder) => {
      builder.addTimeSliderControl(initialInput);
      return {
        initialInput: {
          ...initialInput,
          viewMode: _public.ViewMode.VIEW,
          timeRange: this.props.timeRange
        }
      };
    });
    (0, _defineProperty2.default)(this, "_onLoadComplete", controlGroup => {
      if (!this._isMounted || !controlGroup) {
        return;
      }
      this._subscriptions.add(controlGroup.getOutput$().pipe((0, _rxjs.distinctUntilChanged)(({
        timeslice: timesliceA
      }, {
        timeslice: timesliceB
      }) => _lodash.default.isEqual(timesliceA, timesliceB))).subscribe(({
        timeslice
      }) => {
        // use waitForTimesliceToLoad$ observable to wait until next frame loaded
        // .pipe(first()) waits until the first value is emitted from an observable and then automatically unsubscribes
        this.props.waitForTimesliceToLoad$.pipe((0, _rxjs.first)()).subscribe(() => {
          controlGroup.anyControlOutputConsumerLoading$.next(false);
        });
        this.props.setTimeslice(timeslice === undefined ? undefined : {
          from: timeslice[0],
          to: timeslice[1]
        });
      }));
    });
  }
  componentWillUnmount() {
    this._isMounted = false;
    this._subscriptions.unsubscribe();
  }
  componentDidMount() {
    this._isMounted = true;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "mapTimeslider mapTimeslider--animation"
    }, /*#__PURE__*/_react.default.createElement(_public2.ControlGroupRenderer, {
      ref: this._onLoadComplete,
      getCreationOptions: this._getCreationOptions,
      timeRange: this.props.timeRange
    }));
  }
}
exports.Timeslider = Timeslider;