"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrawFilterControl = void 0;
var _reactRedux = require("react-redux");
var _draw_filter_control = require("./draw_filter_control");
var _actions = require("../../../../actions");
var _map_selectors = require("../../../../selectors/map_selectors");
var _constants = require("../../../../../common/constants");
var _ui_selectors = require("../../../../selectors/ui_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    drawState: (0, _map_selectors.getDrawState)(state),
    filterModeActive: (0, _ui_selectors.getDrawMode)(state) === _constants.DRAW_MODE.DRAW_FILTERS,
    geoFieldNames: (0, _map_selectors.getGeoFieldNames)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    disableDrawState() {
      dispatch((0, _actions.updateDrawState)(null));
      dispatch((0, _actions.setDrawMode)(_constants.DRAW_MODE.NONE));
    }
  };
}
const connected = exports.DrawFilterControl = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_draw_filter_control.DrawFilterControl);