"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEMSClientLazy = createEMSClientLazy;
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let lazyLoaded;
async function createEMSClientLazy(emsSettings, version, buildFlavor = 'traditional') {
  if (lazyLoaded) {
    return await lazyLoaded(emsSettings, version, buildFlavor);
  }
  lazyLoaded = await new Promise(async (resolve, reject) => {
    try {
      try {
        const {
          createEMSClient
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./create_ems_client')));
        resolve(createEMSClient);
      } catch (error) {
        reject(error);
      }
    } catch (error) {
      reject(error);
    }
  });
  return await lazyLoaded(emsSettings, version, buildFlavor);
}