"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEMSClient = createEMSClient;
var _coerce = _interopRequireDefault(require("semver/functions/coerce"));
var _coreHttpCommon = require("@kbn/core-http-common");
var _i18n = require("@kbn/i18n");
var _emsClient = require("@elastic/ems-client");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function createEMSClient(emsSettings, kbnVersion, buildFlavor = 'traditional') {
  let landingPageUrl = emsSettings.getEMSLandingPageUrl();
  const kbnSemVer = (0, _coerce.default)(kbnVersion);
  const isServerless = buildFlavor === 'serverless';
  const headers = new Headers();
  if (!isServerless && kbnSemVer) {
    landingPageUrl = `${landingPageUrl}/v${kbnSemVer.major}.${kbnSemVer.minor}`;
  }
  if (isServerless) {
    headers.append(_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER, _common.DEFAULT_EMS_REST_VERSION);
  }
  const version = isServerless ? _common.DEFAULT_EMS_REST_VERSION : kbnVersion;
  return new _emsClient.EMSClient({
    language: _i18n.i18n.getLocale(),
    appVersion: version,
    emsVersion: version,
    appName: _common.EMS_APP_NAME,
    tileApiUrl: emsSettings.getEMSTileApiUrl(),
    fileApiUrl: emsSettings.getEMSFileApiUrl(),
    landingPageUrl,
    fetchFunction(url) {
      return fetch(url, {
        headers
      });
    },
    proxyPath: ''
  });
}