"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getColumns(openPipeline, clonePipeline) {
  return [{
    field: 'id',
    name: _i18n.i18n.translate('xpack.logstash.pipelinesTable.idColumnLabel', {
      defaultMessage: 'Id'
    }),
    sortable: true,
    render: (id, {
      isCentrallyManaged
    }) => {
      const openPipelineClicked = () => openPipeline(id);
      return isCentrallyManaged ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: openPipelineClicked,
        "data-test-subj": "cellId"
      }, id) : /*#__PURE__*/_react.default.createElement("span", null, id, " \xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _constants.PIPELINE_LIST.PIPELINE_NOT_CENTRALLY_MANAGED_TOOLTIP_TEXT,
        type: "questionInCircle"
      }));
    }
  }, {
    field: 'description',
    name: _i18n.i18n.translate('xpack.logstash.pipelinesTable.descriptionColumnLabel', {
      defaultMessage: 'Description'
    }),
    render: description => /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "cellDescription"
    }, description),
    sortable: true,
    truncateText: true
  }, {
    field: 'lastModifiedHumanized',
    name: _i18n.i18n.translate('xpack.logstash.pipelinesTable.lastModifiedColumnLabel', {
      defaultMessage: 'Last modified'
    }),
    render: lastModified => /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "cellLastModified"
    }, lastModified),
    sortable: ({
      lastModified
    }) => lastModified.valueOf()
  }, {
    field: 'username',
    name: _i18n.i18n.translate('xpack.logstash.pipelinesTable.modifiedByColumnLabel', {
      defaultMessage: 'Modified by'
    }),
    render: username => /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "cellUsername"
    }, username),
    sortable: true
  }, {
    field: 'id',
    name: '',
    render: (id, {
      isCentrallyManaged
    }) => {
      const cloneClicked = () => {
        clonePipeline(id);
      };
      return isCentrallyManaged ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": `lnkPipelineClone-${id}`,
        iconType: "copy",
        onClick: cloneClicked,
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logstash.pipelinesTable.cloneButtonLabel",
        defaultMessage: "Clone"
      })) : null;
    },
    sortable: false,
    width: '100px'
  }];
}
function PipelinesTableUi({
  clonePipeline,
  createPipeline,
  isReadOnly,
  isSelectable,
  message,
  onDeleteSelectedPipelines,
  onSelectionChange,
  openPipeline,
  pipelines,
  selection,
  pageIndex,
  intl
}) {
  const pagination = {
    pageIndex,
    initialPageSize: _constants.PIPELINE_LIST.INITIAL_PAGE_SIZE,
    totalItemCount: pipelines.length,
    pageSizeOptions: _constants.PIPELINE_LIST.PAGE_SIZE_OPTIONS
  };
  const selectableMessage = (selectable, {
    id
  }) => selectable ? intl.formatMessage({
    id: 'xpack.logstash.pipelinesTable.selectablePipelineMessage',
    defaultMessage: `Select pipeline "{id}"`
  }, {
    id
  }) : _constants.PIPELINE_LIST.PIPELINE_NOT_CENTRALLY_MANAGED_TOOLTIP_TEXT;
  const selectionOptions = isSelectable ? {
    selectable: ({
      isCentrallyManaged
    }) => isCentrallyManaged,
    selectableMessage,
    onSelectionChange
  } : null;

  // display when > 0 selected and user has write permission
  const deleteButton = selection.length && !isReadOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    key: "btnDeletePipelines",
    color: "danger",
    onClick: onDeleteSelectedPipelines,
    "data-test-subj": "btnDeletePipeline"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logstash.pipelinesTable.deleteButtonLabel",
    defaultMessage: "Delete"
  })) : null;
  const search = {
    box: {
      incremental: true,
      'data-test-subj': 'filter'
    },
    filters: [{
      type: 'field_value_selection',
      field: 'id',
      name: _i18n.i18n.translate('xpack.logstash.pipelinesTable.filterByIdLabel', {
        defaultMessage: 'Filter by ID'
      }),
      multiSelect: false,
      options: pipelines.map(({
        id
      }) => {
        return {
          value: id,
          name: id,
          view: id
        };
      })
    }],
    toolsLeft: deleteButton,
    toolsRight: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: isReadOnly,
      key: "btnAdd",
      fill: true,
      onClick: createPipeline,
      "data-test-subj": "btnAdd"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.pipelinesTable.createPipelineButtonLabel",
      defaultMessage: "Create pipeline"
    }))
  };
  const columns = getColumns(openPipeline, clonePipeline);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    columns: columns,
    "data-test-subj": "pipelineTable",
    isSelectable: isSelectable,
    itemId: "id",
    items: pipelines,
    message: message,
    pagination: pagination,
    search: search,
    selection: selectionOptions,
    sorting: true,
    rowProps: {
      'data-test-subj': 'row'
    }
  });
}
const PipelinesTable = exports.PipelinesTable = (0, _i18nReact.injectI18n)(PipelinesTableUi);