"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumnWidths = exports.iconColumnId = exports.getColumnWidths = exports.default = exports.LogEntryColumnContent = exports.LogEntryColumn = void 0;
var _react = require("react");
var _common = require("@kbn/kibana-react-plugin/common");
var _moment = _interopRequireDefault(require("moment"));
var _log_column_render_configuration = require("../../../utils/log_column_render_configuration");
var _formatted_time = require("../../formatted_time");
var _text_styles = require("./text_styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATE_COLUMN_SLACK_FACTOR = 1.1;
const FIELD_COLUMN_MIN_WIDTH_CHARACTERS = 10;
const DETAIL_FLYOUT_ICON_MIN_WIDTH = 32;
const COLUMN_PADDING = 8;
const LogEntryColumn = exports.LogEntryColumn = _common.euiStyled.div.attrs(() => ({
  role: 'cell'
}))`
  align-items: stretch;
  display: flex;
  flex-basis: ${props => props.baseWidth || '0%'};
  flex-direction: row;
  flex-grow: ${props => props.growWeight || 0};
  flex-shrink: ${props => props.shrinkWeight || 0};
  overflow: hidden;
`;
const LogEntryColumnContent = exports.LogEntryColumnContent = _common.euiStyled.div.attrs({
  'data-test-subj': 'LogEntryColumnContent'
})`
  flex: 1 0 0%;
  padding: 2px ${COLUMN_PADDING}px;
`;
const iconColumnId = exports.iconColumnId = Symbol('iconColumnId');
const getColumnWidths = (columns, characterWidth, formattedDateWidth) => columns.reduce((columnWidths, column) => {
  if ((0, _log_column_render_configuration.isTimestampColumnRenderConfiguration)(column)) {
    const customWidth = column.timestampColumn.width ? (0, _log_column_render_configuration.columnWidthToCSS)(column.timestampColumn.width) : undefined;
    return {
      ...columnWidths,
      [column.timestampColumn.id]: {
        growWeight: 0,
        shrinkWeight: 0,
        baseWidth: customWidth !== null && customWidth !== void 0 ? customWidth : `${Math.ceil(characterWidth * formattedDateWidth * DATE_COLUMN_SLACK_FACTOR) + 2 * COLUMN_PADDING}px`
      }
    };
  } else if ((0, _log_column_render_configuration.isMessageColumnRenderConfiguration)(column)) {
    const customWidth = column.messageColumn.width ? (0, _log_column_render_configuration.columnWidthToCSS)(column.messageColumn.width) : undefined;
    return {
      ...columnWidths,
      [column.messageColumn.id]: {
        growWeight: 5,
        shrinkWeight: 0,
        baseWidth: customWidth !== null && customWidth !== void 0 ? customWidth : '0%'
      }
    };
  } else {
    const customWidth = column.fieldColumn.width ? (0, _log_column_render_configuration.columnWidthToCSS)(column.fieldColumn.width) : undefined;
    return {
      ...columnWidths,
      [column.fieldColumn.id]: {
        growWeight: customWidth ? 0 : 1,
        shrinkWeight: 0,
        baseWidth: customWidth !== null && customWidth !== void 0 ? customWidth : `${Math.ceil(characterWidth * FIELD_COLUMN_MIN_WIDTH_CHARACTERS) + 2 * COLUMN_PADDING}px`
      }
    };
  }
}, {
  // the detail flyout icon column
  [iconColumnId]: {
    growWeight: 0,
    shrinkWeight: 0,
    baseWidth: `${DETAIL_FLYOUT_ICON_MIN_WIDTH + 2 * COLUMN_PADDING}px`
  }
});

/**
 * This hook calculates the column widths based on the given configuration. It
 * depends on the `CharacterDimensionsProbe` it returns being rendered so it can
 * measure the monospace character size.
 */
exports.getColumnWidths = getColumnWidths;
const useColumnWidths = ({
  columnConfigurations,
  scale,
  timeFormat = 'time'
}) => {
  const {
    CharacterDimensionsProbe,
    dimensions
  } = (0, _text_styles.useMeasuredCharacterDimensions)(scale);
  const referenceTime = (0, _react.useMemo)(() => (0, _moment.default)().toISOString(), []);
  const formattedCurrentDate = (0, _formatted_time.useFormattedTime)(referenceTime, {
    format: timeFormat
  });
  const columnWidths = (0, _react.useMemo)(() => getColumnWidths(columnConfigurations, dimensions.width, formattedCurrentDate.length), [columnConfigurations, dimensions.width, formattedCurrentDate]);
  return (0, _react.useMemo)(() => ({
    columnWidths,
    CharacterDimensionsProbe
  }), [columnWidths, CharacterDimensionsProbe]);
};

// eslint-disable-next-line import/no-default-export
exports.useColumnWidths = useColumnWidths;
var _default = exports.default = LogEntryColumn;