"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeLogsLocatorDefinition = exports.NODE_LOGS_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _locators = require("@kbn/deeplinks-observability/locators");
var _infra = require("./infra");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NODE_LOGS_LOCATOR_ID = exports.NODE_LOGS_LOCATOR_ID = 'NODE_LOGS_LOCATOR';
class NodeLogsLocatorDefinition {
  constructor(locators) {
    (0, _defineProperty2.default)(this, "id", NODE_LOGS_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const infraNodeLogsLocator = this.locators.get(_infra.INFRA_NODE_LOGS_LOCATOR_ID);
      if (infraNodeLogsLocator) {
        return infraNodeLogsLocator.getLocation(params);
      }
      const allDatasetsLocator = this.locators.get(_locators.ALL_DATASETS_LOCATOR_ID);
      const {
        time
      } = params;
      return allDatasetsLocator.getLocation({
        query: (0, _helpers.getNodeQuery)(params),
        ...(time ? {
          timeRange: {
            from: (0, _helpers.getTimeRangeStartFromTime)(time),
            to: (0, _helpers.getTimeRangeEndFromTime)(time)
          }
        } : {})
      });
    });
    this.locators = locators;
  }
}
exports.NodeLogsLocatorDefinition = NodeLogsLocatorDefinition;