"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPropertyGetProxy = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates a Proxy in which certain property accesses are redirected to
 * replacement factories.
 *
 * @param target the object to proxy
 * @param replacements a map of keys to replacement factories
 * @returns a proxy of the object
 */
const createPropertyGetProxy = (target, replacements) => new Proxy(target, {
  get(accessedTarget, accessedKey, ...rest) {
    const value = Reflect.get(accessedTarget, accessedKey, ...rest);
    if (hasKey(replacements, accessedKey)) {
      return replacements[accessedKey](value);
    } else {
      return value;
    }
  }
});
exports.createPropertyGetProxy = createPropertyGetProxy;
const hasKey = (obj, key) => obj.hasOwnProperty(key);