"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEsql = void 0;
var _esqlUtils = require("@kbn/esql-utils");
var _data_source_selection = require("../../common/data_source_selection");
var _use_kibana = require("../utils/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEsql = ({
  dataSourceSelection
}) => {
  var _discover$locator;
  const {
    services: {
      uiSettings,
      discover
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const isEsqlEnabled = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_esqlUtils.ENABLE_ESQL);
  const esqlPattern = (0, _data_source_selection.isDatasetSelection)(dataSourceSelection) ? dataSourceSelection.selection.dataset.name : dataSourceSelection.selection.dataView.title;
  const discoverLinkParams = {
    query: {
      esql: `from ${esqlPattern} | limit 10`
    }
  };
  const href = (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.useUrl(discoverLinkParams);
  const onClick = () => {
    var _discover$locator2;
    (_discover$locator2 = discover.locator) === null || _discover$locator2 === void 0 ? void 0 : _discover$locator2.navigate(discoverLinkParams);
  };
  return {
    // Data
    isEsqlEnabled,
    discoverEsqlUrlProps: {
      href,
      onClick
    }
  };
};
exports.useEsql = useEsql;