"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMessageWithFallbacks = void 0;
exports.useDocDetail = useDocDetail;
var _discoverUtils = require("@kbn/discover-utils");
var constants = _interopRequireWildcard(require("../../common/constants"));
var _use_kibana = require("../utils/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDocDetail(doc, {
  dataView
}) {
  var _levelArray$;
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const formatField = field => {
    return doc.flattened[field] && (0, _discoverUtils.formatFieldValue)(doc.flattened[field], doc.raw, services.fieldFormats, dataView, dataView.fields.getByName(field));
  };

  // Flyout Headers
  const levelArray = doc.flattened[constants.LOG_LEVEL_FIELD];
  const level = levelArray && levelArray.length ? (_levelArray$ = levelArray[0]) === null || _levelArray$ === void 0 ? void 0 : _levelArray$.toLowerCase() : undefined;
  const messageArray = doc.flattened[constants.MESSAGE_FIELD];
  const message = messageArray && messageArray.length ? messageArray[0] : undefined;
  const errorMessageArray = doc.flattened[constants.ERROR_MESSAGE_FIELD];
  const errorMessage = errorMessageArray && errorMessageArray.length ? errorMessageArray[0] : undefined;
  const eventOriginalArray = doc.flattened[constants.EVENT_ORIGINAL_FIELD];
  const eventOriginal = eventOriginalArray && eventOriginalArray.length ? eventOriginalArray[0] : undefined;
  const timestamp = formatField(constants.TIMESTAMP_FIELD);

  // Service Highlights
  const serviceName = formatField(constants.SERVICE_NAME_FIELD);
  const traceId = formatField(constants.TRACE_ID_FIELD);

  // Infrastructure Highlights
  const hostname = formatField(constants.HOST_NAME_FIELD);
  const orchestratorClusterName = formatField(constants.ORCHESTRATOR_CLUSTER_NAME_FIELD);
  const orchestratorResourceId = formatField(constants.ORCHESTRATOR_RESOURCE_ID_FIELD);

  // Cloud Highlights
  const cloudProvider = formatField(constants.CLOUD_PROVIDER_FIELD);
  const cloudRegion = formatField(constants.CLOUD_REGION_FIELD);
  const cloudAz = formatField(constants.CLOUD_AVAILABILITY_ZONE_FIELD);
  const cloudProjectId = formatField(constants.CLOUD_PROJECT_ID_FIELD);
  const cloudInstanceId = formatField(constants.CLOUD_INSTANCE_ID_FIELD);

  // Other Highlights
  const logFilePath = formatField(constants.LOG_FILE_PATH_FIELD);
  const namespace = formatField(constants.DATASTREAM_NAMESPACE_FIELD);
  const dataset = formatField(constants.DATASTREAM_DATASET_FIELD);
  const agentName = formatField(constants.AGENT_NAME_FIELD);
  return {
    [constants.LOG_LEVEL_FIELD]: level,
    [constants.TIMESTAMP_FIELD]: timestamp,
    [constants.MESSAGE_FIELD]: message,
    [constants.ERROR_MESSAGE_FIELD]: errorMessage,
    [constants.EVENT_ORIGINAL_FIELD]: eventOriginal,
    [constants.SERVICE_NAME_FIELD]: serviceName,
    [constants.TRACE_ID_FIELD]: traceId,
    [constants.HOST_NAME_FIELD]: hostname,
    [constants.ORCHESTRATOR_CLUSTER_NAME_FIELD]: orchestratorClusterName,
    [constants.ORCHESTRATOR_RESOURCE_ID_FIELD]: orchestratorResourceId,
    [constants.CLOUD_PROVIDER_FIELD]: cloudProvider,
    [constants.CLOUD_REGION_FIELD]: cloudRegion,
    [constants.CLOUD_AVAILABILITY_ZONE_FIELD]: cloudAz,
    [constants.CLOUD_PROJECT_ID_FIELD]: cloudProjectId,
    [constants.CLOUD_INSTANCE_ID_FIELD]: cloudInstanceId,
    [constants.LOG_FILE_PATH_FIELD]: logFilePath,
    [constants.DATASTREAM_NAMESPACE_FIELD]: namespace,
    [constants.DATASTREAM_DATASET_FIELD]: dataset,
    [constants.AGENT_NAME_FIELD]: agentName
  };
}
const getMessageWithFallbacks = doc => {
  const rankingOrder = [constants.MESSAGE_FIELD, constants.ERROR_MESSAGE_FIELD, constants.EVENT_ORIGINAL_FIELD];
  for (const rank of rankingOrder) {
    if (doc[rank] !== undefined && doc[rank] !== null) {
      return {
        field: rank,
        value: doc[rank]
      };
    }
  }

  // If none of the ranks (fallbacks) are present
  return {
    field: undefined
  };
};
exports.getMessageWithFallbacks = getMessageWithFallbacks;