"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _flyout_detail = require("../components/flyout_detail/flyout_detail");
var _controller = require("../controller");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomFlyoutContent = ({
  filter,
  onAddColumn,
  onRemoveColumn,
  dataView,
  hit
}) => {
  const {
    customizations: {
      flyout
    }
  } = (0, _controller.useLogsExplorerControllerContext)();
  const flyoutContentProps = (0, _react.useMemo)(() => ({
    actions: {
      addFilter: filter,
      addColumn: onAddColumn,
      removeColumn: onRemoveColumn
    },
    dataView,
    doc: hit
  }), [filter, onAddColumn, onRemoveColumn, dataView, hit]);
  const renderCustomizedContent = (0, _react.useMemo)(() => {
    var _flyout$renderContent, _flyout$renderContent2;
    return (_flyout$renderContent = flyout === null || flyout === void 0 ? void 0 : (_flyout$renderContent2 = flyout.renderContent) === null || _flyout$renderContent2 === void 0 ? void 0 : _flyout$renderContent2.call(flyout, renderContent)) !== null && _flyout$renderContent !== void 0 ? _flyout$renderContent : renderContent;
  }, [flyout]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, renderCustomizedContent(flyoutContentProps)));
};
const renderContent = ({
  actions,
  dataView,
  doc
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_flyout_detail.FlyoutDetail, {
  actions: actions,
  dataView: dataView,
  doc: doc
}));

// eslint-disable-next-line import/no-default-export
var _default = exports.default = CustomFlyoutContent;
module.exports = exports.default;