"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCustomControlColumnsConfiguration = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _unifiedDataTable = require("@kbn/unified-data-table");
var _eui = require("@elastic/eui");
var _react2 = require("@xstate/react");
var _translations = require("../components/common/translations");
var constants = _interopRequireWildcard(require("../../common/constants"));
var _get_stack_trace = require("../utils/get_stack_trace");
var _actions_column_tooltip = require("../components/virtual_columns/column_tooltips/actions_column_tooltip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectedDegradedDocs = ({
  rowIndex,
  service
}) => {
  const [state] = (0, _react2.useActor)(service);
  if (state.matches('initialized') && state.context.rows[rowIndex]) {
    return /*#__PURE__*/_react.default.createElement(DegradedDocs, {
      row: state.context.rows[rowIndex],
      rowIndex: rowIndex
    });
  }
  return null;
};
const ConnectedStacktraceDocs = ({
  rowIndex,
  service
}) => {
  const [state] = (0, _react2.useActor)(service);
  if (state.matches('initialized') && state.context.rows[rowIndex]) {
    return /*#__PURE__*/_react.default.createElement(Stacktrace, {
      row: state.context.rows[rowIndex],
      rowIndex: rowIndex
    });
  }
  return null;
};
const DegradedDocs = ({
  row,
  rowIndex
}) => {
  const isDegradedDocumentExists = (constants.DEGRADED_DOCS_FIELD in row.raw);
  return isDegradedDocumentExists ? /*#__PURE__*/_react.default.createElement(_unifiedDataTable.DataTableRowControl, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.degradedDocButtonLabelWhenPresent,
    delay: "long"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    id: `degradedDocExists_${rowIndex}`,
    size: "xs",
    iconSize: "s",
    "data-test-subj": 'docTableDegradedDocExist',
    color: 'danger',
    "aria-label": _translations.degradedDocButtonLabelWhenPresent,
    iconType: 'indexClose'
  }))) : /*#__PURE__*/_react.default.createElement(_unifiedDataTable.DataTableRowControl, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.degradedDocButtonLabelWhenNotPresent,
    delay: "long"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    id: `degradedDocExists_${rowIndex}`,
    size: "xs",
    iconSize: "s",
    "data-test-subj": 'docTableDegradedDocDoesNotExist',
    color: 'text',
    iconType: 'pagesSelect',
    "aria-label": _translations.degradedDocButtonLabelWhenNotPresent
  })));
};
const Stacktrace = ({
  row,
  rowIndex
}) => {
  const stacktrace = (0, _get_stack_trace.getStacktraceFields)(row);
  const hasValue = Object.values(stacktrace).some(value => value);
  return /*#__PURE__*/_react.default.createElement(_unifiedDataTable.DataTableRowControl, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: hasValue ? _translations.stacktraceAvailableControlButton : _translations.stacktraceNotAvailableControlButton,
    delay: "long"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    id: `stacktrace_${rowIndex}`,
    size: "xs",
    iconSize: "s",
    "data-test-subj": hasValue ? 'docTableStacktraceExist' : 'docTableStacktraceDoesNotExist',
    color: 'text',
    iconType: 'apmTrace',
    "aria-label": hasValue ? _translations.stacktraceAvailableControlButton : _translations.stacktraceNotAvailableControlButton,
    disabled: !hasValue
  })));
};
const createCustomControlColumnsConfiguration = service => ({
  controlColumns
}) => {
  const checkBoxColumn = controlColumns[_unifiedDataTable.SELECT_ROW];
  const openDetails = controlColumns[_unifiedDataTable.OPEN_DETAILS];
  const ExpandButton = openDetails.rowCellRender;
  const actionsColumn = {
    id: 'actionsColumn',
    width: constants.ACTIONS_COLUMN_WIDTH,
    headerCellRender: _actions_column_tooltip.ActionsColumnTooltip,
    rowCellRender: ({
      rowIndex,
      setCellProps,
      ...rest
    }) => {
      return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(ExpandButton, (0, _extends2.default)({
        rowIndex: rowIndex,
        setCellProps: setCellProps
      }, rest)), /*#__PURE__*/_react.default.createElement(ConnectedDegradedDocs, {
        rowIndex: rowIndex,
        service: service
      }), /*#__PURE__*/_react.default.createElement(ConnectedStacktraceDocs, {
        rowIndex: rowIndex,
        service: service
      }));
    }
  };
  return {
    leadingControlColumns: [checkBoxColumn],
    trailingControlColumns: [actionsColumn]
  };
};
exports.createCustomControlColumnsConfiguration = createCustomControlColumnsConfiguration;