"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCustomCellRenderer = void 0;
var _constants = require("../../common/constants");
var _cell_renderer = require("../components/virtual_columns/cell_renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCustomCellRenderer = ({
  data
}) => {
  return {
    [_constants.CONTENT_FIELD]: (0, _cell_renderer.renderCell)(_constants.CONTENT_FIELD, {
      data
    }),
    [_constants.RESOURCE_FIELD]: (0, _cell_renderer.renderCell)(_constants.RESOURCE_FIELD, {
      data
    })
  };
};
exports.createCustomCellRenderer = createCustomCellRenderer;