"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightSection = HighlightSection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../common/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHILDREN_PER_SECTION = 6;
function HighlightSection({
  title,
  children,
  columns,
  ...props
}) {
  const validChildren = _react.default.Children.toArray(children).filter(Boolean);
  const childLength = validChildren.length;
  const shouldRenderSection = childLength > 0;
  const limitedChildren = validChildren.slice(0, CHILDREN_PER_SECTION - 1);
  const [showMore, setShowMore] = (0, _react.useState)(childLength > CHILDREN_PER_SECTION);
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: title
  });
  const hiddenCount = childLength - limitedChildren.length;
  const showMoreButtonLabel = (0, _translations.flyoutAccordionShowMoreText)(hiddenCount);
  const showMoreButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "logsExplorerHighlightSectionShowMoreButton",
    size: "xs",
    flush: "left",
    css: {
      width: '80px'
    },
    onClick: () => {
      setShowMore(false);
    }
  }, showMoreButtonLabel);
  limitedChildren.push(showMoreButton);
  const accordionTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, title));
  const flexChildren = (showMore ? limitedChildren : validChildren).map((child, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: idx
  }, child));
  return shouldRenderSection ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, (0, _extends2.default)({
    id: accordionId,
    buttonContent: accordionTitle,
    paddingSize: "m",
    initialIsOpen: true
  }, props), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: columns,
    alignItems: "start",
    gutterSize: "m"
  }, flexChildren)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  })) : null;
}