"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightFieldDescription = HighlightFieldDescription;
exports.default = void 0;
var _eui = require("@elastic/eui");
var _ecs = require("@elastic/ecs");
var _reactField = require("@kbn/react-field");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HighlightFieldDescription({
  fieldName
}) {
  var _EcsFlat;
  const {
    short,
    type
  } = (_EcsFlat = _ecs.EcsFlat[fieldName]) !== null && _EcsFlat !== void 0 ? _EcsFlat : {};
  if (!short) return null;
  const title = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, type && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
    type: type,
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, fieldName));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    title: title,
    content: short,
    color: "subdued"
  });
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = HighlightFieldDescription;