"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasNonUndefinedSubChild = children => {
  return children.some(child => {
    if ( /*#__PURE__*/_react.default.isValidElement(child)) {
      const subChildren = _react.default.Children.toArray(child.props.children);
      return subChildren.some(subChild => subChild !== undefined && subChild !== null);
    }
    return false;
  });
};
const HighlightContainer = exports.HighlightContainer = /*#__PURE__*/_react.default.forwardRef(({
  children
}, ref) => {
  const validChildren = _react.default.Children.toArray(children).filter(Boolean);
  const hasChildren = validChildren.length > 0;
  const shouldRender = hasChildren && hasNonUndefinedSubChild(validChildren);
  const flexChildren = validChildren.map((child, idx) => /*#__PURE__*/_react.default.createElement("div", {
    key: idx
  }, child));
  return shouldRender ? /*#__PURE__*/_react.default.createElement("div", {
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), flexChildren) : null;
});