"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutHighlights = FlyoutHighlights;
var _react = _interopRequireDefault(require("react"));
var _customIcons = require("@kbn/custom-icons");
var _lib = require("react-use/lib");
var _lodash = require("lodash");
var constants = _interopRequireWildcard(require("../../../common/constants"));
var _highlight_field = require("./sub_components/highlight_field");
var _translations = require("../common/translations");
var _highlight_section = require("./sub_components/highlight_section");
var _highlight_container = require("./sub_components/highlight_container");
var _use_flyouot_column_width = require("../../hooks/use_flyouot_column_width");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlyoutHighlights({
  formattedDoc,
  flattenedDoc
}) {
  var _flattenedDoc$constan;
  const [ref, dimensions] = (0, _lib.useMeasure)();
  const {
    columns,
    fieldWidth
  } = (0, _use_flyouot_column_width.useFlyoutColumnWidth)(dimensions.width);
  return /*#__PURE__*/_react.default.createElement(_highlight_container.HighlightContainer, {
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_highlight_section.HighlightSection, {
    title: _translations.serviceInfraAccordionTitle,
    columns: columns,
    "data-test-subj": "logsExplorerFlyoutHighlightSectionServiceInfra"
  }, formattedDoc[constants.SERVICE_NAME_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutService",
    field: constants.SERVICE_NAME_FIELD,
    formattedValue: formattedDoc[constants.SERVICE_NAME_FIELD],
    label: _translations.flyoutServiceLabel,
    value: flattenedDoc[constants.SERVICE_NAME_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.HOST_NAME_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutHostName",
    field: constants.HOST_NAME_FIELD,
    formattedValue: formattedDoc[constants.HOST_NAME_FIELD],
    label: _translations.flyoutHostNameLabel,
    value: flattenedDoc[constants.HOST_NAME_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.TRACE_ID_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutTrace",
    field: constants.TRACE_ID_FIELD,
    formattedValue: formattedDoc[constants.TRACE_ID_FIELD],
    label: _translations.flyoutTraceLabel,
    value: flattenedDoc[constants.TRACE_ID_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.ORCHESTRATOR_CLUSTER_NAME_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutClusterName",
    field: constants.ORCHESTRATOR_CLUSTER_NAME_FIELD,
    formattedValue: formattedDoc[constants.ORCHESTRATOR_CLUSTER_NAME_FIELD],
    label: _translations.flyoutOrchestratorClusterNameLabel,
    value: flattenedDoc[constants.ORCHESTRATOR_CLUSTER_NAME_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.ORCHESTRATOR_RESOURCE_ID_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutResourceId",
    field: constants.ORCHESTRATOR_RESOURCE_ID_FIELD,
    formattedValue: formattedDoc[constants.ORCHESTRATOR_RESOURCE_ID_FIELD],
    label: _translations.flyoutOrchestratorResourceIdLabel,
    value: flattenedDoc[constants.ORCHESTRATOR_RESOURCE_ID_FIELD],
    width: fieldWidth
  })), /*#__PURE__*/_react.default.createElement(_highlight_section.HighlightSection, {
    title: _translations.cloudAccordionTitle,
    columns: columns,
    "data-test-subj": "logsExplorerFlyoutHighlightSectionCloud"
  }, formattedDoc[constants.CLOUD_PROVIDER_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutCloudProvider",
    field: constants.CLOUD_PROVIDER_FIELD,
    formattedValue: formattedDoc[constants.CLOUD_PROVIDER_FIELD],
    icon: /*#__PURE__*/_react.default.createElement(_customIcons.CloudProviderIcon, {
      cloudProvider: (0, _lodash.first)((_flattenedDoc$constan = flattenedDoc[constants.CLOUD_PROVIDER_FIELD]) !== null && _flattenedDoc$constan !== void 0 ? _flattenedDoc$constan : [])
    }),
    label: _translations.flyoutCloudProviderLabel,
    value: flattenedDoc[constants.CLOUD_PROVIDER_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.CLOUD_REGION_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutCloudRegion",
    field: constants.CLOUD_REGION_FIELD,
    formattedValue: formattedDoc[constants.CLOUD_REGION_FIELD],
    label: _translations.flyoutCloudRegionLabel,
    value: flattenedDoc[constants.CLOUD_REGION_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.CLOUD_AVAILABILITY_ZONE_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutCloudAz",
    field: constants.CLOUD_AVAILABILITY_ZONE_FIELD,
    formattedValue: formattedDoc[constants.CLOUD_AVAILABILITY_ZONE_FIELD],
    label: _translations.flyoutCloudAvailabilityZoneLabel,
    value: flattenedDoc[constants.CLOUD_AVAILABILITY_ZONE_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.CLOUD_PROJECT_ID_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutCloudProjectId",
    field: constants.CLOUD_PROJECT_ID_FIELD,
    formattedValue: formattedDoc[constants.CLOUD_PROJECT_ID_FIELD],
    label: _translations.flyoutCloudProjectIdLabel,
    value: flattenedDoc[constants.CLOUD_PROJECT_ID_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.CLOUD_INSTANCE_ID_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutCloudInstanceId",
    field: constants.CLOUD_INSTANCE_ID_FIELD,
    formattedValue: formattedDoc[constants.CLOUD_INSTANCE_ID_FIELD],
    label: _translations.flyoutCloudInstanceIdLabel,
    value: flattenedDoc[constants.CLOUD_INSTANCE_ID_FIELD],
    width: fieldWidth
  })), /*#__PURE__*/_react.default.createElement(_highlight_section.HighlightSection, {
    title: _translations.otherAccordionTitle,
    columns: columns,
    "data-test-subj": "logsExplorerFlyoutHighlightSectionOther"
  }, formattedDoc[constants.LOG_FILE_PATH_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutLogPathFile",
    field: constants.LOG_FILE_PATH_FIELD,
    formattedValue: formattedDoc[constants.LOG_FILE_PATH_FIELD],
    label: _translations.flyoutLogPathFileLabel,
    value: flattenedDoc[constants.LOG_FILE_PATH_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.DATASTREAM_DATASET_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutDataset",
    field: constants.DATASTREAM_DATASET_FIELD,
    formattedValue: formattedDoc[constants.DATASTREAM_DATASET_FIELD],
    label: _translations.flyoutDatasetLabel,
    value: flattenedDoc[constants.DATASTREAM_DATASET_FIELD],
    width: fieldWidth
  }), formattedDoc[constants.DATASTREAM_NAMESPACE_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutNamespace",
    field: constants.DATASTREAM_NAMESPACE_FIELD,
    formattedValue: formattedDoc[constants.DATASTREAM_NAMESPACE_FIELD],
    label: _translations.flyoutNamespaceLabel,
    value: flattenedDoc[constants.DATASTREAM_NAMESPACE_FIELD],
    width: fieldWidth,
    useBadge: true
  }), formattedDoc[constants.AGENT_NAME_FIELD] && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    "data-test-subj": "logsExplorerFlyoutLogShipper",
    field: constants.AGENT_NAME_FIELD,
    formattedValue: formattedDoc[constants.AGENT_NAME_FIELD],
    label: _translations.flyoutShipperLabel,
    value: flattenedDoc[constants.AGENT_NAME_FIELD],
    width: fieldWidth
  })));
}