"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutDetail = FlyoutDetail;
var _react = _interopRequireDefault(require("react"));
var _use_doc_detail = require("../../hooks/use_doc_detail");
var _flyout_header = require("./flyout_header");
var _flyout_highlights = require("./flyout_highlights");
var _use_discover_action = require("../../hooks/use_discover_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlyoutDetail({
  dataView,
  doc,
  actions
}) {
  const parsedDoc = (0, _use_doc_detail.useDocDetail)(doc, {
    dataView
  });
  return /*#__PURE__*/_react.default.createElement(_use_discover_action.DiscoverActionsProvider, {
    value: actions
  }, /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, {
    doc: parsedDoc
  }), /*#__PURE__*/_react.default.createElement(_flyout_highlights.FlyoutHighlights, {
    formattedDoc: parsedDoc,
    flattenedDoc: doc.flattened
  }));
}