"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stacktraceNotAvailableControlButton = exports.stacktraceAvailableControlButton = exports.serviceInfraAccordionTitle = exports.resourceLabel = exports.resourceHeaderTooltipParagraph = exports.otherAccordionTitle = exports.openCellActionPopoverAriaText = exports.flyoutTraceLabel = exports.flyoutShipperLabel = exports.flyoutServiceLabel = exports.flyoutOrchestratorResourceIdLabel = exports.flyoutOrchestratorClusterNameLabel = exports.flyoutNamespaceLabel = exports.flyoutLogPathFileLabel = exports.flyoutHoverActionToggleColumnText = exports.flyoutHoverActionFilterForFieldPresentText = exports.flyoutHoverActionCopyToClipboardText = exports.flyoutHostNameLabel = exports.flyoutDatasetLabel = exports.flyoutContentLabel = exports.flyoutCloudRegionLabel = exports.flyoutCloudProviderLabel = exports.flyoutCloudProjectIdLabel = exports.flyoutCloudInstanceIdLabel = exports.flyoutCloudAvailabilityZoneLabel = exports.flyoutAccordionShowMoreText = exports.filterOutText = exports.filterForText = exports.degradedDocButtonLabelWhenPresent = exports.degradedDocButtonLabelWhenNotPresent = exports.copyValueText = exports.copyValueAriaText = exports.contentLabel = exports.contentHeaderTooltipParagraph2 = exports.contentHeaderTooltipParagraph1 = exports.cloudAccordionTitle = exports.closeCellActionPopoverText = exports.actionsLabelLowerCase = exports.actionsLabel = exports.actionsHeaderTooltipStacktraceAction = exports.actionsHeaderTooltipParagraph = exports.actionsHeaderTooltipExpandAction = exports.actionsHeaderTooltipDegradedAction = exports.actionFilterOutText = exports.actionFilterForText = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flyoutContentLabel = exports.flyoutContentLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.message', {
  defaultMessage: 'Content breakdown'
});
const contentLabel = exports.contentLabel = _i18n.i18n.translate('xpack.logsExplorer.dataTable.header.popover.content', {
  defaultMessage: 'Content'
});
const resourceLabel = exports.resourceLabel = _i18n.i18n.translate('xpack.logsExplorer.dataTable.header.popover.resource', {
  defaultMessage: 'Resource'
});
const actionsLabel = exports.actionsLabel = _i18n.i18n.translate('xpack.logsExplorer.dataTable.header.popover.actions', {
  defaultMessage: 'Actions'
});
const actionsLabelLowerCase = exports.actionsLabelLowerCase = _i18n.i18n.translate('xpack.logsExplorer.dataTable.header.popover.actions.lowercase', {
  defaultMessage: 'actions'
});
const flyoutServiceLabel = exports.flyoutServiceLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.service', {
  defaultMessage: 'Service'
});
const flyoutTraceLabel = exports.flyoutTraceLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.trace', {
  defaultMessage: 'Trace'
});
const flyoutHostNameLabel = exports.flyoutHostNameLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.hostName', {
  defaultMessage: 'Host name'
});
const serviceInfraAccordionTitle = exports.serviceInfraAccordionTitle = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.accordion.title.serviceInfra', {
  defaultMessage: 'Service & Infrastructure'
});
const cloudAccordionTitle = exports.cloudAccordionTitle = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.accordion.title.cloud', {
  defaultMessage: 'Cloud'
});
const otherAccordionTitle = exports.otherAccordionTitle = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.accordion.title.other', {
  defaultMessage: 'Other'
});
const flyoutOrchestratorClusterNameLabel = exports.flyoutOrchestratorClusterNameLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.orchestratorClusterName', {
  defaultMessage: 'Orchestrator cluster Name'
});
const flyoutOrchestratorResourceIdLabel = exports.flyoutOrchestratorResourceIdLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.orchestratorResourceId', {
  defaultMessage: 'Orchestrator resource ID'
});
const flyoutCloudProviderLabel = exports.flyoutCloudProviderLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.cloudProvider', {
  defaultMessage: 'Cloud provider'
});
const flyoutCloudRegionLabel = exports.flyoutCloudRegionLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.cloudRegion', {
  defaultMessage: 'Cloud region'
});
const flyoutCloudAvailabilityZoneLabel = exports.flyoutCloudAvailabilityZoneLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.cloudAvailabilityZone', {
  defaultMessage: 'Cloud availability zone'
});
const flyoutCloudProjectIdLabel = exports.flyoutCloudProjectIdLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.cloudProjectId', {
  defaultMessage: 'Cloud project ID'
});
const flyoutCloudInstanceIdLabel = exports.flyoutCloudInstanceIdLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.cloudInstanceId', {
  defaultMessage: 'Cloud instance ID'
});
const flyoutLogPathFileLabel = exports.flyoutLogPathFileLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.logPathFile', {
  defaultMessage: 'Log path file'
});
const flyoutNamespaceLabel = exports.flyoutNamespaceLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.namespace', {
  defaultMessage: 'Namespace'
});
const flyoutDatasetLabel = exports.flyoutDatasetLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.dataset', {
  defaultMessage: 'Dataset'
});
const flyoutShipperLabel = exports.flyoutShipperLabel = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.label.shipper', {
  defaultMessage: 'Shipper'
});
const actionFilterForText = text => _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.value.hover.filterFor', {
  defaultMessage: 'Filter for this {value}',
  values: {
    value: text
  }
});
exports.actionFilterForText = actionFilterForText;
const actionFilterOutText = text => _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.value.hover.filterOut', {
  defaultMessage: 'Filter out this {value}',
  values: {
    value: text
  }
});
exports.actionFilterOutText = actionFilterOutText;
const filterOutText = exports.filterOutText = _i18n.i18n.translate('xpack.logsExplorer.popoverAction.filterOut', {
  defaultMessage: 'Filter out'
});
const filterForText = exports.filterForText = _i18n.i18n.translate('xpack.logsExplorer.popoverAction.filterFor', {
  defaultMessage: 'Filter for'
});
const flyoutHoverActionFilterForFieldPresentText = exports.flyoutHoverActionFilterForFieldPresentText = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.value.hover.filterForFieldPresent', {
  defaultMessage: 'Filter for field present'
});
const flyoutHoverActionToggleColumnText = exports.flyoutHoverActionToggleColumnText = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.value.hover.toggleColumn', {
  defaultMessage: 'Toggle column in table'
});
const flyoutHoverActionCopyToClipboardText = exports.flyoutHoverActionCopyToClipboardText = _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.value.hover.copyToClipboard', {
  defaultMessage: 'Copy to clipboard'
});
const copyValueText = exports.copyValueText = _i18n.i18n.translate('xpack.logsExplorer.popoverAction.copyValue', {
  defaultMessage: 'Copy value'
});
const copyValueAriaText = fieldName => _i18n.i18n.translate('xpack.logsExplorer.popoverAction.copyValueAriaText', {
  defaultMessage: 'Copy value of {fieldName}',
  values: {
    fieldName
  }
});
exports.copyValueAriaText = copyValueAriaText;
const flyoutAccordionShowMoreText = count => _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.section.showMore', {
  defaultMessage: '+ {hiddenCount} more',
  values: {
    hiddenCount: count
  }
});
exports.flyoutAccordionShowMoreText = flyoutAccordionShowMoreText;
const openCellActionPopoverAriaText = exports.openCellActionPopoverAriaText = _i18n.i18n.translate('xpack.logsExplorer.popoverAction.openPopover', {
  defaultMessage: 'Open popover'
});
const closeCellActionPopoverText = exports.closeCellActionPopoverText = _i18n.i18n.translate('xpack.logsExplorer.popoverAction.closePopover', {
  defaultMessage: 'Close popover'
});
const contentHeaderTooltipParagraph1 = exports.contentHeaderTooltipParagraph1 = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.logsExplorer.dataTable.header.content.tooltip.paragraph1",
  defaultMessage: "Displays the document's {logLevel} and {message} fields.",
  values: {
    logLevel: /*#__PURE__*/_react.default.createElement("strong", null, "log.level"),
    message: /*#__PURE__*/_react.default.createElement("strong", null, "message")
  }
});
const contentHeaderTooltipParagraph2 = exports.contentHeaderTooltipParagraph2 = _i18n.i18n.translate('xpack.logsExplorer.dataTable.header.content.tooltip.paragraph2', {
  defaultMessage: 'When the message field is empty, one of the following is displayed:'
});
const resourceHeaderTooltipParagraph = exports.resourceHeaderTooltipParagraph = _i18n.i18n.translate('xpack.logsExplorer.dataTable.header.resource.tooltip.paragraph', {
  defaultMessage: "Fields that provide information on the document's source, such as:"
});
const actionsHeaderTooltipParagraph = exports.actionsHeaderTooltipParagraph = _i18n.i18n.translate('xpack.logsExplorer.dataTable.header.actions.tooltip.paragraph', {
  defaultMessage: 'Fields that provide actionable information, such as:'
});
const actionsHeaderTooltipExpandAction = exports.actionsHeaderTooltipExpandAction = _i18n.i18n.translate('xpack.logsExplorer.dataTable.header.actions.tooltip.expand', {
  defaultMessage: 'Expand log details'
});
const actionsHeaderTooltipDegradedAction = exports.actionsHeaderTooltipDegradedAction = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.logsExplorer.dataTable.controlColumn.actions.button.degradedDoc",
  defaultMessage: "Access to degraded doc with {ignoredProperty} field",
  values: {
    ignoredProperty: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      language: "json",
      transparentBackground: true
    }, "_ignored")
  }
});
const actionsHeaderTooltipStacktraceAction = exports.actionsHeaderTooltipStacktraceAction = _i18n.i18n.translate('xpack.logsExplorer.dataTable.header.actions.tooltip.stacktrace', {
  defaultMessage: 'Access to available stacktraces based on:'
});
const degradedDocButtonLabelWhenPresent = exports.degradedDocButtonLabelWhenPresent = _i18n.i18n.translate('xpack.logsExplorer.dataTable.controlColumn.actions.button.degradedDocPresent', {
  defaultMessage: "This document couldn't be parsed correctly. Not all fields are properly populated"
});
const degradedDocButtonLabelWhenNotPresent = exports.degradedDocButtonLabelWhenNotPresent = _i18n.i18n.translate('xpack.logsExplorer.dataTable.controlColumn.actions.button.degradedDocNotPresent', {
  defaultMessage: 'All fields in this document were parsed correctly'
});
const stacktraceAvailableControlButton = exports.stacktraceAvailableControlButton = _i18n.i18n.translate('xpack.logsExplorer.dataTable.controlColumn.actions.button.stacktrace.available', {
  defaultMessage: 'Stacktraces available'
});
const stacktraceNotAvailableControlButton = exports.stacktraceNotAvailableControlButton = _i18n.i18n.translate('xpack.logsExplorer.dataTable.controlColumn.actions.button.stacktrace.notAvailable', {
  defaultMessage: 'Stacktraces not available'
});