"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AllDatasetSelection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _datasets = require("../datasets");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AllDatasetSelection {
  constructor() {
    (0, _defineProperty2.default)(this, "selectionType", void 0);
    (0, _defineProperty2.default)(this, "selection", void 0);
    this.selectionType = 'all';
    this.selection = {
      dataset: _datasets.Dataset.createAllLogsDataset()
    };
  }
  toDataviewSpec() {
    return this.selection.dataset.toDataviewSpec();
  }
  toPlainSelection() {
    return {
      selectionType: this.selectionType
    };
  }
  static create() {
    return new AllDatasetSelection();
  }
}
exports.AllDatasetSelection = AllDatasetSelection;