"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLinksClient = getLinksClient;
exports.linksClient = void 0;
var _common = require("../../common");
var _kibana_services = require("../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const get = async id => {
  return _kibana_services.contentManagement.client.get({
    contentTypeId: _common.CONTENT_ID,
    id
  });
};
const create = async ({
  data,
  options
}) => {
  const res = await _kibana_services.contentManagement.client.create({
    contentTypeId: _common.CONTENT_ID,
    data,
    options
  });
  return res;
};
const update = async ({
  id,
  data,
  options
}) => {
  const res = await _kibana_services.contentManagement.client.update({
    contentTypeId: _common.CONTENT_ID,
    id,
    data,
    options
  });
  return res;
};
const deleteLinks = async id => {
  await _kibana_services.contentManagement.client.delete({
    contentTypeId: _common.CONTENT_ID,
    id
  });
};
const search = async (query = {}, options) => {
  return _kibana_services.contentManagement.client.search({
    contentTypeId: _common.CONTENT_ID,
    query,
    options
  });
};
const linksClient = exports.linksClient = {
  get,
  create,
  update,
  delete: deleteLinks,
  search
};
function getLinksClient() {
  return linksClient;
}