"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksComponent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useMap = _interopRequireDefault(require("react-use/lib/useMap"));
var _content_management = require("../../common/content_management");
var _links_editor_tools = require("../editor/links_editor_tools");
var _dashboard_link_component = require("./dashboard_link/dashboard_link_component");
var _external_link_component = require("./external_link/external_link_component");
require("./links_component.scss");
var _links_hooks = require("./links_hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LinksComponent = () => {
  var _linksAttributes$link, _linksAttributes$layo3;
  const linksEmbeddable = (0, _links_hooks.useLinks)();
  const linksAttributes = (0, _links_hooks.useLinksAttributes)();
  const [linksLoading, {
    set: setLinkIsLoading
  }] = (0, _useMap.default)(Object.fromEntries(((_linksAttributes$link = linksAttributes === null || linksAttributes === void 0 ? void 0 : linksAttributes.links) !== null && _linksAttributes$link !== void 0 ? _linksAttributes$link : []).map(link => {
    return [link.id, true];
  })));
  (0, _react.useEffect)(() => {
    if (Object.values(linksLoading).includes(true)) {
      linksEmbeddable.onLoading();
    } else {
      linksEmbeddable.onRender();
    }
  }, [linksLoading, linksEmbeddable]);
  const orderedLinks = (0, _react.useMemo)(() => {
    if (!(linksAttributes !== null && linksAttributes !== void 0 && linksAttributes.links)) return [];
    return (0, _links_editor_tools.memoizedGetOrderedLinkList)(linksAttributes === null || linksAttributes === void 0 ? void 0 : linksAttributes.links);
  }, [linksAttributes]);
  const linkItems = (0, _react.useMemo)(() => {
    var _linksAttributes$link2;
    return ((_linksAttributes$link2 = linksAttributes === null || linksAttributes === void 0 ? void 0 : linksAttributes.links) !== null && _linksAttributes$link2 !== void 0 ? _linksAttributes$link2 : []).reduce((prev, currentLink) => {
      var _linksAttributes$layo, _linksAttributes$layo2;
      return {
        ...prev,
        [currentLink.id]: {
          id: currentLink.id,
          content: currentLink.type === _content_management.DASHBOARD_LINK_TYPE ? /*#__PURE__*/_react.default.createElement(_dashboard_link_component.DashboardLinkComponent, {
            key: currentLink.id,
            link: currentLink,
            layout: (_linksAttributes$layo = linksAttributes === null || linksAttributes === void 0 ? void 0 : linksAttributes.layout) !== null && _linksAttributes$layo !== void 0 ? _linksAttributes$layo : _content_management.LINKS_VERTICAL_LAYOUT,
            onLoading: () => setLinkIsLoading(currentLink.id, true),
            onRender: () => setLinkIsLoading(currentLink.id, false)
          }) : /*#__PURE__*/_react.default.createElement(_external_link_component.ExternalLinkComponent, {
            key: currentLink.id,
            link: currentLink,
            layout: (_linksAttributes$layo2 = linksAttributes === null || linksAttributes === void 0 ? void 0 : linksAttributes.layout) !== null && _linksAttributes$layo2 !== void 0 ? _linksAttributes$layo2 : _content_management.LINKS_VERTICAL_LAYOUT,
            onRender: () => setLinkIsLoading(currentLink.id, false)
          })
        }
      };
    }, {});
  }, [linksAttributes === null || linksAttributes === void 0 ? void 0 : linksAttributes.links, linksAttributes === null || linksAttributes === void 0 ? void 0 : linksAttributes.layout, setLinkIsLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: `linksComponent ${(linksAttributes === null || linksAttributes === void 0 ? void 0 : linksAttributes.layout) === _content_management.LINKS_HORIZONTAL_LAYOUT ? 'eui-xScroll' : 'eui-yScroll'}`,
    paddingSize: "xs",
    "data-test-subj": "links--component"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    maxWidth: false,
    className: `${(_linksAttributes$layo3 = linksAttributes === null || linksAttributes === void 0 ? void 0 : linksAttributes.layout) !== null && _linksAttributes$layo3 !== void 0 ? _linksAttributes$layo3 : _content_management.LINKS_VERTICAL_LAYOUT}LayoutWrapper`,
    "data-test-subj": "links--component--listGroup"
  }, orderedLinks.map(link => linkItems[link.id].content)));
};
exports.LinksComponent = LinksComponent;