"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractReferences = extractReferences;
exports.injectReferences = injectReferences;
var _lodash = require("lodash");
var _content_management = require("../content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function extractReferences({
  attributes,
  references = []
}) {
  if (!attributes.links) {
    return {
      attributes,
      references
    };
  }
  const {
    links
  } = attributes;
  const extractedReferences = [];
  const newLinks = links.map(link => {
    if (link.type === _content_management.DASHBOARD_LINK_TYPE && link.destination) {
      const refName = `link_${link.id}_dashboard`;
      extractedReferences.push({
        name: refName,
        type: 'dashboard',
        id: link.destination
      });
      return {
        ...(0, _lodash.omit)(link, 'destination'),
        destinationRefName: refName
      };
    }
    return link;
  });
  return {
    attributes: {
      ...attributes,
      links: newLinks
    },
    references: references.concat(extractedReferences)
  };
}
function findReference(targetName, references) {
  const reference = references.find(({
    name
  }) => name === targetName);
  if (!reference) {
    throw new Error(`Could not find reference "${targetName}"`);
  }
  return reference;
}
function injectReferences({
  attributes,
  references
}) {
  if (!attributes.links) {
    return {
      attributes
    };
  }
  const {
    links
  } = attributes;
  links.forEach(link => {
    if (link.type === _content_management.DASHBOARD_LINK_TYPE && link.destinationRefName) {
      const reference = findReference(link.destinationRefName, references);
      link.destination = reference.id;
      delete link.destinationRefName;
    }
  });
  return {
    attributes: {
      ...attributes,
      links
    }
  };
}