"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseManagementUIPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _constants = require("../common/constants");
var _breadcrumbs = require("./application/breadcrumbs");
var _locator = require("./locator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class LicenseManagementUIPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "breadcrumbService", new _breadcrumbs.BreadcrumbService());
    (0, _defineProperty2.default)(this, "locator", void 0);
    this.initializerContext = initializerContext;
  }
  setup(coreSetup, plugins) {
    const config = this.initializerContext.config.get();
    if (!config.ui.enabled) {
      // No need to go any further
      return {
        enabled: false,
        locator: this.locator
      };
    }
    const {
      getStartServices
    } = coreSetup;
    const {
      management,
      licensing,
      share
    } = plugins;
    this.locator = share.url.locators.create(new _locator.LicenseManagementLocatorDefinition({
      managementAppLocator: management.locator
    }));
    management.sections.section.stack.registerApp({
      id: _constants.PLUGIN.id,
      title: _constants.PLUGIN.title,
      order: 0,
      mount: async ({
        element,
        setBreadcrumbs,
        history
      }) => {
        const [coreStart, {
          telemetry
        }] = await getStartServices();
        const initialLicense = await (0, _rxjs.firstValueFrom)(plugins.licensing.license$);

        // Setup documentation links
        const {
          docLinks,
          chrome: {
            docTitle
          }
        } = coreStart;
        const appDocLinks = {
          security: docLinks.links.security.elasticsearchSettings
        };
        docTitle.change(_constants.PLUGIN.title);

        // Setup services
        this.breadcrumbService.setup(setBreadcrumbs);
        const appDependencies = {
          core: coreStart,
          config,
          plugins: {
            licensing,
            telemetry
          },
          services: {
            breadcrumbService: this.breadcrumbService,
            history
          },
          store: {
            initialLicense
          },
          docLinks: appDocLinks
        };
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const unmountAppCallback = renderApp(element, appDependencies);
        return () => {
          docTitle.reset();
          unmountAppCallback();
        };
      }
    });
    return {
      enabled: true,
      locator: this.locator
    };
  }
  start() {}
  stop() {}
}
exports.LicenseManagementUIPlugin = LicenseManagementUIPlugin;