"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Toolbar = Toolbar;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _shared_components = require("../../shared_components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Toolbar(props) {
  const {
    state,
    setState
  } = props;
  const setSubtitle = (0, _react.useCallback)(prefix => setState({
    ...state,
    subtitle: prefix
  }), [setState, state]);
  const {
    inputValue: subtitleInputVal,
    handleInputChange: handleSubtitleChange
  } = (0, _visualizationUiComponents.useDebouncedValue)({
    onChange: setSubtitle,
    value: state.subtitle || ''
  }, {
    allowFalsyValue: true
  });
  const hasBreakdownBy = Boolean(state.breakdownByAccessor);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, !hasBreakdownBy && /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.metric.labels', {
      defaultMessage: 'Labels'
    }),
    type: "labels",
    groupPosition: "none",
    buttonDataTestSubj: "lnsLabelsButton"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.metric.subtitleLabel', {
      defaultMessage: 'Subtitle'
    }),
    fullWidth: true,
    display: "columnCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: subtitleInputVal,
    onChange: ({
      target: {
        value
      }
    }) => handleSubtitleChange(value)
  }))));
}