"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeEditEmbeddableAction = executeEditEmbeddableAction;
exports.isEmbeddableEditActionCompatible = isEmbeddableEditActionCompatible;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _esqlUtils = require("@kbn/esql-utils");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _utils = require("../../../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function isEmbeddableEditActionCompatible(core, attributes) {
  // for ES|QL is compatible only when advanced setting is enabled
  const query = attributes.state.query;
  return (0, _esQuery.isOfAggregateQueryType)(query) ? core.uiSettings.get(_esqlUtils.ENABLE_ESQL) : true;
}
async function executeEditEmbeddableAction({
  deps,
  core,
  attributes,
  lensEvent,
  container,
  onUpdate,
  onApply,
  onCancel
}) {
  const isCompatibleAction = isEmbeddableEditActionCompatible(core, attributes);
  if (!isCompatibleAction) {
    throw new _public2.IncompatibleActionError();
  }
  const {
    getEditLensConfiguration,
    getVisualizationMap,
    getDatasourceMap
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../../async_services')));
  const visualizationMap = getVisualizationMap();
  const datasourceMap = getDatasourceMap();
  const query = attributes.state.query;
  const activeDatasourceId = (0, _esQuery.isOfAggregateQueryType)(query) ? 'textBased' : 'formBased';
  const onUpdatePanelState = (datasourceState, visualizationState, visualizationType) => {
    if (attributes.state) {
      const datasourceStates = {
        ...attributes.state.datasourceStates,
        [activeDatasourceId]: datasourceState
      };
      const references = (0, _utils.extractReferencesFromState)({
        activeDatasources: Object.keys(datasourceStates).reduce((acc, datasourceId) => ({
          ...acc,
          [datasourceId]: datasourceMap[datasourceId]
        }), {}),
        datasourceStates: Object.fromEntries(Object.entries(datasourceStates).map(([id, state]) => [id, {
          isLoading: false,
          state
        }])),
        visualizationState,
        activeVisualization: visualizationType ? visualizationMap[visualizationType] : undefined
      });
      const attrs = {
        ...attributes,
        state: {
          ...attributes.state,
          visualization: visualizationState,
          datasourceStates
        },
        references,
        visualizationType: visualizationType !== null && visualizationType !== void 0 ? visualizationType : attributes.visualizationType
      };
      onUpdate(attrs);
    }
  };
  const onUpdateSuggestion = attrs => {
    const newAttributes = {
      ...attributes,
      ...attrs
    };
    onUpdate(newAttributes);
  };
  const Component = await getEditLensConfiguration(core, deps, visualizationMap, datasourceMap);
  const ConfigPanel = /*#__PURE__*/_react.default.createElement(Component, {
    attributes: attributes,
    updatePanelState: onUpdatePanelState,
    lensAdapters: lensEvent === null || lensEvent === void 0 ? void 0 : lensEvent.adapters,
    output$: lensEvent === null || lensEvent === void 0 ? void 0 : lensEvent.embeddableOutput$,
    displayFlyoutHeader: true,
    datasourceId: activeDatasourceId,
    onApplyCb: onApply,
    onCancelCb: onCancel,
    canEditTextBasedQuery: activeDatasourceId === 'textBased',
    updateSuggestion: onUpdateSuggestion,
    hideTimeFilterInfo: true
  });

  // in case an element is given render the component in the container,
  // otherwise a flyout will open
  if (container) {
    _reactDom.default.render(ConfigPanel, container);
  } else {
    const handle = core.overlays.openFlyout((0, _public.toMountPoint)( /*#__PURE__*/_react.default.cloneElement(ConfigPanel, {
      closeFlyout: () => {
        handle.close();
      }
    }), {
      theme$: core.theme.theme$
    }), {
      className: 'lnsConfigPanel__overlay',
      size: 's',
      'data-test-subj': 'customizeLens',
      type: 'push',
      paddingSize: 'm',
      hideCloseButton: true,
      onClose: overlayRef => {
        overlayRef.close();
      },
      outsideClickCloses: true
    });
  }
}