"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAsyncHelpers = exports.EditLensEmbeddableAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ACTION_EDIT_LENS_EMBEDDABLE = 'ACTION_EDIT_LENS_EMBEDDABLE';
const getAsyncHelpers = async () => await Promise.resolve().then(() => _interopRequireWildcard(require('../../../async_services')));
exports.getAsyncHelpers = getAsyncHelpers;
class EditLensEmbeddableAction {
  constructor(startDependencies, core) {
    (0, _defineProperty2.default)(this, "type", ACTION_EDIT_LENS_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "id", ACTION_EDIT_LENS_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "order", 50);
    this.startDependencies = startDependencies;
    this.core = core;
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.lens.app.editLensEmbeddableLabel', {
      defaultMessage: 'Edit visualization'
    });
  }
  getIconType() {
    return 'pencil';
  }
  async isCompatible({
    attributes
  }) {
    const {
      isEmbeddableEditActionCompatible
    } = await getAsyncHelpers();
    return isEmbeddableEditActionCompatible(this.core, attributes);
  }
  async execute({
    attributes,
    lensEvent,
    container,
    onUpdate,
    onApply,
    onCancel
  }) {
    const {
      executeEditEmbeddableAction
    } = await getAsyncHelpers();
    if (attributes) {
      executeEditEmbeddableAction({
        deps: this.startDependencies,
        core: this.core,
        attributes,
        lensEvent,
        container,
        onUpdate,
        onApply,
        onCancel
      });
    }
  }
}
exports.EditLensEmbeddableAction = EditLensEmbeddableAction;