"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendLocationSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toggleButtonsIcons = [{
  id: _charts.Position.Right,
  label: _i18n.i18n.translate('xpack.lens.shared.legendPositionRight', {
    defaultMessage: 'Right'
  }),
  iconType: 'sortRight'
}, {
  id: _charts.Position.Left,
  label: _i18n.i18n.translate('xpack.lens.shared.legendPositionLeft', {
    defaultMessage: 'Left'
  }),
  iconType: 'sortLeft'
}, {
  id: _charts.Position.Top,
  label: _i18n.i18n.translate('xpack.lens.shared.legendPositionTop', {
    defaultMessage: 'Top'
  }),
  iconType: 'sortUp'
}, {
  id: _charts.Position.Bottom,
  label: _i18n.i18n.translate('xpack.lens.shared.legendPositionBottom', {
    defaultMessage: 'Bottom'
  }),
  iconType: 'sortDown'
}];
const locationOptions = [{
  id: `xy_location_outside`,
  value: 'outside',
  label: _i18n.i18n.translate('xpack.lens.xyChart.legendLocation.outside', {
    defaultMessage: 'Outside'
  })
}, {
  id: `xy_location_inside`,
  value: 'inside',
  label: _i18n.i18n.translate('xpack.lens.xyChart.legendLocation.inside', {
    defaultMessage: 'Inside'
  })
}];
const locationAlignmentButtonsIcons = [{
  id: 'xy_location_alignment_top_right',
  value: 'top_right',
  label: _i18n.i18n.translate('xpack.lens.shared.legendLocationTopRight', {
    defaultMessage: 'Top right'
  }),
  iconType: 'editorPositionTopRight'
}, {
  id: 'xy_location_alignment_top_left',
  value: 'top_left',
  label: _i18n.i18n.translate('xpack.lens.shared.legendLocationTopLeft', {
    defaultMessage: 'Top left'
  }),
  iconType: 'editorPositionTopLeft'
}, {
  id: 'xy_location_alignment_bottom_right',
  value: 'bottom_right',
  label: _i18n.i18n.translate('xpack.lens.shared.legendLocationBottomRight', {
    defaultMessage: 'Bottom right'
  }),
  iconType: 'editorPositionBottomRight'
}, {
  id: 'xy_location_alignment_bottom_left',
  value: 'bottom_left',
  label: _i18n.i18n.translate('xpack.lens.shared.legendLocationBottomLeft', {
    defaultMessage: 'Bottom left'
  }),
  iconType: 'editorPositionBottomLeft'
}];
const LegendLocationSettings = ({
  location,
  onLocationChange = () => {},
  position,
  onPositionChange,
  verticalAlignment,
  horizontalAlignment,
  onAlignmentChange = () => {},
  isDisabled = false
}) => {
  const alignment = `${verticalAlignment || _charts.VerticalAlignment.Top}_${horizontalAlignment || _charts.HorizontalAlignment.Right}`;
  if (isDisabled) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, location && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.shared.legendPosition', {
      defaultMessage: 'Legend position'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.shared.legendPosition', {
      defaultMessage: 'Legend position'
    }),
    "data-test-subj": "lens-legend-location-btn",
    buttonSize: "compressed",
    options: locationOptions,
    isDisabled: isDisabled,
    idSelected: locationOptions.find(({
      value
    }) => value === location).id,
    onChange: optionId => {
      const newLocation = locationOptions.find(({
        id
      }) => id === optionId).value;
      onLocationChange(newLocation);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (!location || location === 'outside') && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.shared.legendAlignmentLabel', {
      defaultMessage: 'Alignment'
    }),
    isDisabled: isDisabled,
    "data-test-subj": "lens-legend-position-btn",
    buttonSize: "compressed",
    options: toggleButtonsIcons,
    idSelected: position || _charts.Position.Right,
    onChange: onPositionChange,
    isIconOnly: true
  }), location === 'inside' && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.shared.legendInsideLocationAlignmentLabel', {
      defaultMessage: 'Alignment'
    }),
    type: "single",
    "data-test-subj": "lens-legend-inside-alignment-btn",
    buttonSize: "compressed",
    isDisabled: isDisabled,
    options: locationAlignmentButtonsIcons,
    idSelected: locationAlignmentButtonsIcons.find(({
      value
    }) => value === alignment).id,
    onChange: optionId => {
      const newAlignment = locationAlignmentButtonsIcons.find(({
        id
      }) => id === optionId).value;
      onAlignmentChange(newAlignment);
    },
    isIconOnly: true
  }))))));
};
exports.LegendLocationSettings = LegendLocationSettings;