"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_FLOATING_COLUMNS = exports.ColumnsNumberSetting = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_FLOATING_COLUMNS = exports.DEFAULT_FLOATING_COLUMNS = 1;
const ColumnsNumberSetting = ({
  floatingColumns,
  onFloatingColumnsChange = () => {},
  isLegendOutside
}) => {
  const {
    inputValue,
    handleInputChange
  } = (0, _visualizationUiComponents.useDebouncedValue)({
    value: floatingColumns !== null && floatingColumns !== void 0 ? floatingColumns : DEFAULT_FLOATING_COLUMNS,
    onChange: onFloatingColumnsChange
  });
  if (isLegendOutside) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.shared.legendInsideColumnsLabel', {
      defaultMessage: 'Number of columns'
    }),
    fullWidth: true,
    display: "columnCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "lens-legend-location-columns-input",
    value: inputValue,
    min: 1,
    max: 5,
    compressed: true,
    onChange: e => {
      handleInputChange(Number(e.target.value));
    },
    step: 1
  }));
};
exports.ColumnsNumberSetting = ColumnsNumberSetting;