"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutContainer = FlyoutContainer;
require("./flyout_container.scss");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function fromExcludedClickTarget(event) {
  for (let node = event.target; node !== null; node = node.parentElement) {
    if (node.classList.contains(_utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS) || node.classList.contains('euiBody-hasPortalContent') || node.getAttribute('data-euiportal') === 'true') {
      return true;
    }
  }
  return false;
}
function FlyoutContainer({
  isOpen,
  label,
  handleClose,
  isFullscreen,
  panelRef,
  panelContainerRef,
  children,
  customFooter,
  isInlineEditing
}) {
  const [focusTrapIsEnabled, setFocusTrapIsEnabled] = (0, _react.useState)(false);
  const closeFlyout = (0, _react.useCallback)(() => {
    setFocusTrapIsEnabled(false);
    handleClose();
  }, [handleClose]);
  (0, _react.useEffect)(() => {
    if (!isInlineEditing) {
      document.body.classList.toggle('lnsBody--overflowHidden', isOpen);
      return () => {
        if (isOpen) {
          setFocusTrapIsEnabled(false);
        }
        document.body.classList.remove('lnsBody--overflowHidden');
      };
    }
  }, [isInlineEditing, isOpen]);
  if (!isOpen) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: panelRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    disabled: !focusTrapIsEnabled,
    clickOutsideDisables: false,
    onClickOutside: event => {
      if (isFullscreen || fromExcludedClickTarget(event)) {
        return;
      }
      closeFlyout();
    },
    onEscapeKey: closeFlyout
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: panelContainerRef,
    role: "dialog",
    "aria-labelledby": "lnsDimensionContainerTitle",
    className: "lnsDimensionContainer",
    css: (0, _react2.css)`
            box-shadow: ${isInlineEditing ? 'none !important' : 'inherit'};
          `,
    onAnimationEnd: () => {
      if (isOpen) {
        // EuiFocusTrap interferes with animating elements with absolute position:
        // running this onAnimationEnd, otherwise the flyout pushes content when animating.
        // The EuiFocusTrap is disabled when inline editing as it causes bugs with comboboxes
        setFocusTrapIsEnabled(!Boolean(isInlineEditing));
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    className: "lnsDimensionContainer__header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false
  }, isInlineEditing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    "data-test-subj": "lns-indexPattern-dimensionContainerBack",
    className: "lnsDimensionContainer__backIcon",
    onClick: closeFlyout,
    iconType: "sortLeft",
    "aria-label": _i18n.i18n.translate('xpack.lens.dimensionContainer.closeConfiguration', {
      defaultMessage: 'Close configuration'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "lnsDimensionContainerTitle",
    className: "lnsDimensionContainer__headerTitle"
  }, label))), !isInlineEditing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    "data-test-subj": "lns-indexPattern-dimensionContainerBack",
    className: "lnsDimensionContainer__backIcon",
    onClick: closeFlyout,
    iconType: "cross",
    "aria-label": _i18n.i18n.translate('xpack.lens.dimensionContainer.closeConfiguration', {
      defaultMessage: 'Close configuration'
    })
  })))), /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsDimensionContainer__content"
  }, children), customFooter || /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    className: "lnsDimensionContainer__footer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    iconType: isInlineEditing ? 'sortLeft' : 'cross',
    onClick: closeFlyout,
    "data-test-subj": "lns-indexPattern-dimensionContainerClose"
  }, isInlineEditing ? _i18n.i18n.translate('xpack.lens.dimensionContainer.back', {
    defaultMessage: 'Back'
  }) : _i18n.i18n.translate('xpack.lens.dimensionContainer.close', {
    defaultMessage: 'Close'
  }))))));
}