"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensAttributeService = getLensAttributeService;
exports.savedObjectToEmbeddableAttributes = void 0;
var _persistence = require("./persistence");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const savedObjectToEmbeddableAttributes = savedObject => {
  return {
    ...savedObject.attributes,
    state: savedObject.attributes.state,
    references: savedObject.references
  };
};
exports.savedObjectToEmbeddableAttributes = savedObjectToEmbeddableAttributes;
function getLensAttributeService(core, startDependencies) {
  const savedObjectStore = new _persistence.SavedObjectIndexStore(startDependencies.contentManagement);
  return startDependencies.embeddable.getAttributeService(_constants.DOC_TYPE, {
    saveMethod: async (attributes, savedObjectId) => {
      const savedDoc = await savedObjectStore.save({
        ...attributes,
        savedObjectId,
        type: _constants.DOC_TYPE
      });
      return {
        id: savedDoc.savedObjectId
      };
    },
    unwrapMethod: async savedObjectId => {
      const {
        item: savedObject,
        meta: {
          outcome,
          aliasTargetId,
          aliasPurpose
        }
      } = await savedObjectStore.load(savedObjectId);
      const {
        id
      } = savedObject;
      const sharingSavedObjectProps = {
        aliasTargetId,
        outcome,
        aliasPurpose,
        sourceId: id
      };
      return {
        attributes: savedObjectToEmbeddableAttributes(savedObject),
        metaInfo: {
          sharingSavedObjectProps,
          managed: savedObject.managed
        }
      };
    },
    checkForDuplicateTitle: props => {
      const overlays = core.overlays;
      return (0, _persistence.checkForDuplicateTitle)({
        title: props.newTitle,
        displayName: _constants.DOC_TYPE,
        isTitleDuplicateConfirmed: props.isTitleDuplicateConfirmed,
        lastSavedTitle: '',
        copyOnSave: false
      }, props.onTitleDuplicate, {
        client: savedObjectStore,
        overlays
      });
    }
  });
}