"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartSwitch = void 0;
require("./chart_switch.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _suggestion_helpers = require("../../suggestion_helpers");
var _lens_ui_errors = require("../../../../lens_ui_errors");
var _state_management = require("../../../../state_management");
var _id_generator = require("../../../../id_generator/id_generator");
var _chart_option_append = require("./chart_option_append");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_LIST_HEIGHT = 380;
const ENTRY_HEIGHT = 32;
function computeListHeight(list, maxHeight) {
  if (list.length === 0) {
    return 0;
  }
  return Math.min(list.length * ENTRY_HEIGHT, maxHeight);
}
function safeFnCall(action, defaultReturnValue) {
  try {
    return action();
  } catch (error) {
    (0, _lens_ui_errors.showMemoizedErrorNotification)(error);
    return defaultReturnValue;
  }
}
function getCurrentVisualizationId(activeVisualization, visualizationState) {
  return safeFnCall(() => activeVisualization.getVisualizationTypeId(visualizationState), undefined);
}
const ChartSwitch = exports.ChartSwitch = /*#__PURE__*/(0, _react.memo)(function ChartSwitch({
  framePublicAPI,
  visualizationMap,
  datasourceMap,
  layerId
}) {
  var _visualizationMap$vis;
  const [flyoutOpen, setFlyoutOpen] = (0, _react.useState)(false);
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const activeDatasourceId = (0, _state_management.useLensSelector)(_state_management.selectActiveDatasourceId);
  const visualization = (0, _state_management.useLensSelector)(_state_management.selectVisualization);
  const datasourceStates = (0, _state_management.useLensSelector)(_state_management.selectDatasourceStates);
  const commitSelection = selection => {
    (0, _suggestion_helpers.switchToSuggestion)(dispatchLens, {
      ...selection,
      visualizationState: selection.getVisualizationState()
    }, {
      clearStagedPreview: true
    });
    if (!selection.datasourceId && !selection.sameDatasources || selection.dataLoss === 'everything') {
      dispatchLens((0, _state_management.removeLayers)({
        visualizationId: visualization.activeId,
        layerIds: Object.keys(framePublicAPI.datasourceLayers)
      }));
    }
  };
  function getSelection(visualizationId, subVisualizationId) {
    var _layers$0$;
    const newVisualization = visualizationMap[visualizationId];
    const switchVisType = (type, state, lId) => {
      if (visualizationMap[visualizationId].switchVisualizationType) {
        return safeFnCall(() => visualizationMap[visualizationId].switchVisualizationType(type, state, lId), state);
      }
      return state;
    };
    const layers = Object.entries(framePublicAPI.datasourceLayers);
    const containsData = layers.some(([_layerId, datasource]) => datasource && datasource.getTableSpec().length > 0);

    // Always show the active visualization as a valid selection
    if (visualization.activeId === visualizationId && visualization.state && safeFnCall(() => {
      var _newVisualization$isS;
      return newVisualization.getVisualizationTypeId(visualization.state) === subVisualizationId || ((_newVisualization$isS = newVisualization.isSubtypeCompatible) === null || _newVisualization$isS === void 0 ? void 0 : _newVisualization$isS.call(newVisualization, newVisualization.getVisualizationTypeId(visualization.state), subVisualizationId));
    }, false)) {
      return {
        visualizationId,
        subVisualizationId,
        dataLoss: 'nothing',
        keptLayerIds: Object.keys(framePublicAPI.datasourceLayers),
        getVisualizationState: () => switchVisType(subVisualizationId, visualization.state, layerId),
        sameDatasources: true
      };
    }
    const topSuggestion = getTopSuggestion(visualizationMap, datasourceMap, framePublicAPI, visualizationId, datasourceStates, visualization, newVisualization, subVisualizationId, layerId);
    let dataLoss;
    if (!containsData) {
      dataLoss = 'nothing';
    } else if (!topSuggestion) {
      dataLoss = 'everything';
    } else if (layers.length > 1 && layers.length > topSuggestion.keptLayerIds.length) {
      dataLoss = 'layers';
    } else if (topSuggestion.columns !== ((_layers$0$ = layers[0][1]) === null || _layers$0$ === void 0 ? void 0 : _layers$0$.getTableSpec().length)) {
      dataLoss = 'columns';
    } else {
      dataLoss = 'nothing';
    }
    function addNewLayer() {
      const newLayerId = (0, _id_generator.generateId)();
      dispatchLens((0, _state_management.insertLayer)({
        datasourceId: activeDatasourceId,
        layerId: newLayerId
      }));
      return newLayerId;
    }
    return {
      visualizationId,
      subVisualizationId,
      dataLoss,
      getVisualizationState: topSuggestion ? () => switchVisType(subVisualizationId, newVisualization.initialize(addNewLayer, topSuggestion.visualizationState), layerId) : () => switchVisType(subVisualizationId, newVisualization.initialize(addNewLayer, visualization.activeId === newVisualization.id ? visualization.state : undefined, visualization.activeId && visualizationMap[visualization.activeId].getMainPalette ? visualizationMap[visualization.activeId].getMainPalette(visualization.state) : undefined), layerId),
      keptLayerIds: topSuggestion ? topSuggestion.keptLayerIds : [],
      datasourceState: topSuggestion ? topSuggestion.datasourceState : undefined,
      datasourceId: topSuggestion ? topSuggestion.datasourceId : undefined,
      sameDatasources: dataLoss === 'nothing' && visualization.activeId === newVisualization.id
    };
  }
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const {
    visualizationTypes,
    visualizationsLookup
  } = (0, _react.useMemo)(() => {
    if (!flyoutOpen) {
      return {
        visualizationTypes: [],
        visualizationsLookup: {}
      };
    }
    const subVisualizationId = visualization.activeId && visualizationMap[visualization.activeId] ? getCurrentVisualizationId(visualizationMap[visualization.activeId], visualization.state) : undefined;
    const lowercasedSearchTerm = searchTerm.toLowerCase();
    // reorganize visualizations in groups
    const grouped = {};
    // Will need it later on to quickly pick up the metadata from it
    const lookup = {};
    Object.entries(visualizationMap).forEach(([visualizationId, v]) => {
      for (const visualizationType of v.visualizationTypes) {
        var _visualizationType$fu;
        const isSearchMatch = visualizationType.label.toLowerCase().includes(lowercasedSearchTerm) || ((_visualizationType$fu = visualizationType.fullLabel) === null || _visualizationType$fu === void 0 ? void 0 : _visualizationType$fu.toLowerCase().includes(lowercasedSearchTerm));
        if (isSearchMatch) {
          grouped[visualizationType.groupLabel] = grouped[visualizationType.groupLabel] || {
            priority: 0,
            visualizations: []
          };
          const visualizationEntry = {
            ...visualizationType,
            visualizationId,
            selection: getSelection(visualizationId, visualizationType.id)
          };
          grouped[visualizationType.groupLabel].priority += visualizationType.sortPriority || 0;
          grouped[visualizationType.groupLabel].visualizations.push(visualizationEntry);
          lookup[`${visualizationId}:${visualizationType.id}`] = visualizationEntry;
        }
      }
    });
    return {
      visualizationTypes: Object.keys(grouped).sort((groupA, groupB) => {
        return grouped[groupB].priority - grouped[groupA].priority;
      }).flatMap(group => {
        const {
          visualizations
        } = grouped[group];
        if (visualizations.length === 0) {
          return [];
        }
        return [{
          key: group,
          label: group,
          isGroupLabel: true,
          'aria-label': group,
          'data-test-subj': `lnsChartSwitchPopover_${group}`
        }].concat(visualizations
        // alphabetical order within each group
        .sort((a, b) => {
          var _b$sortOrder, _a$sortOrder;
          return ((_b$sortOrder = b.sortOrder) !== null && _b$sortOrder !== void 0 ? _b$sortOrder : 0) - ((_a$sortOrder = a.sortOrder) !== null && _a$sortOrder !== void 0 ? _a$sortOrder : 0) || (a.fullLabel || a.label).localeCompare(b.fullLabel || b.label);
        }).map(v => {
          return {
            'aria-label': v.fullLabel || v.label,
            className: 'lnsChartSwitch__option',
            isGroupLabel: false,
            key: `${v.visualizationId}:${v.id}`,
            value: `${v.visualizationId}:${v.id}`,
            'data-test-subj': `lnsChartSwitchPopover_${v.id}`,
            label: v.fullLabel || v.label,
            prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
              className: "lnsChartSwitch__chartIcon",
              type: v.icon || 'empty'
            }),
            append: v.selection.dataLoss !== 'nothing' || v.showExperimentalBadge ? /*#__PURE__*/_react.default.createElement(_chart_option_append.ChartOptionAppend, {
              dataLoss: v.selection.dataLoss,
              showExperimentalBadge: v.showExperimentalBadge,
              id: v.selection.subVisualizationId
            }) : null,
            // Apparently checked: null is not valid for TS
            ...(subVisualizationId === v.id && {
              checked: 'on'
            })
          };
        }));
      }),
      visualizationsLookup: lookup
    };
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [flyoutOpen, visualizationMap, framePublicAPI, visualization.activeId, visualization.state, searchTerm]);
  const {
    icon,
    label
  } = visualization.activeId && ((_visualizationMap$vis = visualizationMap[visualization.activeId]) === null || _visualizationMap$vis === void 0 ? void 0 : _visualizationMap$vis.getDescription(visualization.state, layerId)) || {
    label: _i18n.i18n.translate('xpack.lens.configPanel.selectVisualization', {
      defaultMessage: 'Select a visualization'
    }),
    icon: undefined
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsChartSwitch__header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "lnsChartSwitchPopover",
    ownFocus: true,
    initialFocus: ".lnsChartSwitch__popoverPanel",
    panelClassName: "lnsChartSwitch__popoverPanel",
    panelPaddingSize: "s",
    button: /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.ChartSwitchTrigger, {
      icon: icon,
      label: label,
      dataTestSubj: "lnsChartSwitchPopover",
      onClick: () => setFlyoutOpen(!flyoutOpen)
    }),
    isOpen: flyoutOpen,
    closePopover: () => setFlyoutOpen(false),
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.lens.configPanel.visualizationType', {
    defaultMessage: 'Visualization type'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    className: "lnsChartSwitch__options",
    height: computeListHeight(visualizationTypes, MAX_LIST_HEIGHT),
    searchable: true,
    singleSelection: true,
    isPreFiltered: true,
    "data-test-subj": "lnsChartSwitchList",
    searchProps: {
      className: 'lnsChartSwitch__search',
      'data-test-subj': 'lnsChartSwitchSearch',
      onChange: value => setSearchTerm(value)
    },
    options: visualizationTypes,
    onChange: newOptions => {
      setFlyoutOpen(false);
      const chosenType = newOptions.find(({
        checked
      }) => checked === 'on');
      if (!chosenType) {
        return;
      }
      const id = chosenType.value;
      commitSelection(visualizationsLookup[id].selection);
    },
    noMatchesMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.chartSwitch.noResults",
      defaultMessage: "No results found for {term}.",
      values: {
        term: /*#__PURE__*/_react.default.createElement("strong", null, searchTerm)
      }
    })
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list))));
});
function getTopSuggestion(visualizationMap, datasourceMap, framePublicAPI, visualizationId, datasourceStates, visualization, newVisualization, subVisualizationId, layerId) {
  const mainPalette = visualization.activeId && visualizationMap[visualization.activeId] && visualizationMap[visualization.activeId].getMainPalette ? visualizationMap[visualization.activeId].getMainPalette(visualization.state) : undefined;
  const unfilteredSuggestions = (0, _suggestion_helpers.getSuggestions)({
    datasourceMap,
    datasourceStates,
    visualizationMap: {
      [visualizationId]: newVisualization
    },
    activeVisualization: visualization.activeId ? visualizationMap[visualization.activeId] : undefined,
    visualizationState: visualization.state,
    subVisualizationId,
    activeData: framePublicAPI.activeData,
    mainPalette,
    dataViews: framePublicAPI.dataViews
  });
  const suggestions = unfilteredSuggestions.filter(suggestion => {
    // don't use extended versions of current data table on switching between visualizations
    // to avoid confusing the user.
    return suggestion.changeType !== 'extended' && safeFnCall(() => newVisualization.getVisualizationTypeId(suggestion.visualizationState) === subVisualizationId, false);
  });
  return suggestions.find(s => s.changeType === 'unchanged' || s.changeType === 'reduced') || suggestions.find(s => s.keptLayerIds.some(id => id === layerId)) || suggestions[0];
}