"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextBasedDimensionTrigger = TextBasedDimensionTrigger;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _textBasedEditor = require("@kbn/text-based-editor");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _fieldlist_cache = require("../fieldlist_cache");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TextBasedDimensionTrigger(props) {
  var _props$state$layers$p, _props$state$layers$p2, _props$state$layers$p3, _customLabel;
  const [dataHasLoaded, setDataHasLoaded] = (0, _react.useState)(false);
  const query = (_props$state$layers$p = props.state.layers[props.layerId]) === null || _props$state$layers$p === void 0 ? void 0 : _props$state$layers$p.query;
  (0, _react.useEffect)(() => {
    // in case the columns are not in the cache, I refetch them
    async function fetchColumns() {
      const fieldList = query ? (0, _fieldlist_cache.getColumnsFromCache)(query) : [];
      if (fieldList.length === 0 && query) {
        const table = await (0, _textBasedEditor.fetchFieldsFromESQL)(query, props.expressions);
        if (table) {
          (0, _fieldlist_cache.addColumnsToCache)(query, table.columns);
        }
      }
      setDataHasLoaded(true);
    }
    fetchColumns();
  }, [props.expressions, query]);
  const allColumns = dataHasLoaded ? (0, _fieldlist_cache.retrieveLayerColumnsFromCache)((_props$state$layers$p2 = (_props$state$layers$p3 = props.state.layers[props.layerId]) === null || _props$state$layers$p3 === void 0 ? void 0 : _props$state$layers$p3.columns) !== null && _props$state$layers$p2 !== void 0 ? _props$state$layers$p2 : [], query) : [];
  const selectedField = allColumns === null || allColumns === void 0 ? void 0 : allColumns.find(column => column.columnId === props.columnId);
  let customLabel = props.columnLabelMap[props.columnId];
  if (!customLabel) {
    customLabel = selectedField === null || selectedField === void 0 ? void 0 : selectedField.fieldName;
  }
  return /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DimensionTrigger, {
    id: props.columnId,
    color: customLabel && selectedField ? 'primary' : 'danger',
    dataTestSubj: "lns-dimensionTrigger-textBased",
    label: (_customLabel = customLabel) !== null && _customLabel !== void 0 ? _customLabel : _i18n.i18n.translate('xpack.lens.textBasedLanguages.missingField', {
      defaultMessage: 'Missing field'
    })
  });
}