"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextBasedDimensionEditor = TextBasedDimensionEditor;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _field_select = require("./field_select");
var _fieldlist_cache = require("../fieldlist_cache");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TextBasedDimensionEditor(props) {
  var _props$state$layers$p, _props$state$layers$p2, _props$state$layers$p3;
  const query = (_props$state$layers$p = props.state.layers[props.layerId]) === null || _props$state$layers$p === void 0 ? void 0 : _props$state$layers$p.query;
  const allColumns = (0, _fieldlist_cache.retrieveLayerColumnsFromCache)((_props$state$layers$p2 = (_props$state$layers$p3 = props.state.layers[props.layerId]) === null || _props$state$layers$p3 === void 0 ? void 0 : _props$state$layers$p3.columns) !== null && _props$state$layers$p2 !== void 0 ? _props$state$layers$p2 : [], query);
  const allFields = query ? (0, _fieldlist_cache.getColumnsFromCache)(query) : [];
  const hasNumberTypeColumns = allColumns === null || allColumns === void 0 ? void 0 : allColumns.some(_utils.isNumeric);
  const fields = allFields.map(col => {
    var _col$meta, _col$meta2;
    return {
      id: col.id,
      name: col.name,
      meta: (_col$meta = col === null || col === void 0 ? void 0 : col.meta) !== null && _col$meta !== void 0 ? _col$meta : {
        type: 'number'
      },
      compatible: props.isMetricDimension && hasNumberTypeColumns ? props.filterOperations({
        dataType: col === null || col === void 0 ? void 0 : (_col$meta2 = col.meta) === null || _col$meta2 === void 0 ? void 0 : _col$meta2.type,
        isBucketed: Boolean((0, _utils.isNotNumeric)(col)),
        scale: 'ordinal'
      }) : true
    };
  });
  const selectedField = allColumns === null || allColumns === void 0 ? void 0 : allColumns.find(column => column.columnId === props.columnId);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "text-based-languages-field-selection-row",
    label: _i18n.i18n.translate('xpack.lens.textBasedLanguages.chooseField', {
      defaultMessage: 'Field'
    }),
    fullWidth: true,
    className: "lnsIndexPatternDimensionEditor--padded"
  }, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    existingFields: fields !== null && fields !== void 0 ? fields : [],
    selectedField: selectedField,
    onChoose: choice => {
      var _fields$find;
      const meta = fields === null || fields === void 0 ? void 0 : (_fields$find = fields.find(f => f.name === choice.field)) === null || _fields$find === void 0 ? void 0 : _fields$find.meta;
      const newColumn = {
        columnId: props.columnId,
        fieldName: choice.field,
        meta
      };
      return props.setState(!selectedField ? {
        ...props.state,
        layers: {
          ...props.state.layers,
          [props.layerId]: {
            ...props.state.layers[props.layerId],
            columns: [...props.state.layers[props.layerId].columns, newColumn]
          }
        }
      } : {
        ...props.state,
        layers: {
          ...props.state.layers,
          [props.layerId]: {
            ...props.state.layers[props.layerId],
            columns: props.state.layers[props.layerId].columns.map(col => col.columnId !== props.columnId ? col : {
              ...col,
              fieldName: choice.field,
              meta
            })
          }
        }
      });
    }
  })), props.dataSectionExtra && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      paddingLeft: _uiTheme.euiThemeVars.euiSize,
      paddingRight: _uiTheme.euiThemeVars.euiSize
    }
  }, props.dataSectionExtra));
}