"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextBasedDataPanel = TextBasedDataPanel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _unifiedFieldList = require("@kbn/unified-field-list");
var _utils = require("../utils");
var _field_item = require("../../common/field_item");
var _fieldlist_cache = require("../fieldlist_cache");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCustomFieldType = field => field === null || field === void 0 ? void 0 : field.meta.type;
function TextBasedDataPanel({
  setState,
  state,
  core,
  data,
  query,
  frame,
  filters,
  dateRange,
  expressions,
  dataViews,
  layerFields,
  hasSuggestionForField,
  dropOntoWorkspace
}) {
  const prevQuery = (0, _usePrevious.default)(query);
  const [dataHasLoaded, setDataHasLoaded] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    async function fetchData() {
      if (query && (0, _esQuery.isOfAggregateQueryType)(query) && !(0, _lodash.isEqual)(query, prevQuery)) {
        const frameDataViews = frame.dataViews;
        const stateFromQuery = await (0, _utils.getStateFromAggregateQuery)(state, query, dataViews, data, expressions, frameDataViews);
        setDataHasLoaded(true);
        setState(stateFromQuery);
      }
    }
    fetchData();
  }, [data, dataViews, expressions, prevQuery, query, setState, state, frame.dataViews]);
  const fieldList = (0, _esQuery.isOfAggregateQueryType)(query) ? (0, _fieldlist_cache.getColumnsFromCache)(query) : [];
  const onSelectedFieldFilter = (0, _react.useCallback)(field => {
    return Boolean(layerFields === null || layerFields === void 0 ? void 0 : layerFields.includes(field.name));
  }, [layerFields]);
  const onOverrideFieldGroupDetails = (0, _react.useCallback)(groupName => {
    if (groupName === _unifiedFieldList.FieldsGroupNames.AvailableFields) {
      return {
        helpText: _i18n.i18n.translate('xpack.lens.indexPattern.allFieldsForTextBasedLabelHelp', {
          defaultMessage: 'Drag and drop available fields to the workspace and create visualizations. To change the available fields, edit your query.'
        })
      };
    }
  }, []);
  const {
    fieldListFiltersProps,
    fieldListGroupedProps
  } = (0, _unifiedFieldList.useGroupedFields)({
    dataViewId: null,
    allFields: dataHasLoaded ? fieldList !== null && fieldList !== void 0 ? fieldList : [] : null,
    services: {
      dataViews,
      core
    },
    getCustomFieldType,
    onSelectedFieldFilter,
    onOverrideFieldGroupDetails
  });
  const renderFieldItem = (0, _react.useCallback)(({
    field,
    groupIndex,
    itemIndex,
    fieldSearchHighlight,
    groupName
  }) => {
    if (!field) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    }
    return /*#__PURE__*/_react.default.createElement(_field_item.FieldItem, {
      field: field,
      exists: true,
      hideDetails: true,
      itemIndex: itemIndex,
      groupIndex: groupIndex,
      dropOntoWorkspace: dropOntoWorkspace,
      hasSuggestionForField: hasSuggestionForField,
      highlight: fieldSearchHighlight,
      getCustomFieldType: getCustomFieldType
    });
  }, [hasSuggestionForField, dropOntoWorkspace]);
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core
    }
  }, /*#__PURE__*/_react.default.createElement(_unifiedFieldList.FieldList, {
    className: "lnsInnerIndexPatternDataPanel",
    isProcessing: !dataHasLoaded,
    prepend: /*#__PURE__*/_react.default.createElement(_unifiedFieldList.FieldListFilters, (0, _extends2.default)({}, fieldListFiltersProps, {
      "data-test-subj": "lnsTextBasedLanguages"
    }))
  }, /*#__PURE__*/_react.default.createElement(_unifiedFieldList.FieldListGrouped, (0, _extends2.default)({}, fieldListGroupedProps, {
    renderFieldItem: renderFieldItem,
    "data-test-subj": "lnsTextBasedLanguages",
    localStorageKeyPrefix: "lens"
  }))));
}