"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestions = exports.getQueryColumns = void 0;
var _esqlUtils = require("@kbn/esql-utils");
var _visualizationUtils = require("@kbn/visualization-utils");
var _textBasedEditor = require("@kbn/text-based-editor");
var _lens_suggestions_api = require("../../../lens_suggestions_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getQueryColumns = async (query, deps, abortController) => {
  // Fetching only columns for ES|QL for performance reasons with limit 0
  // Important note: ES doesnt return the warnings for 0 limit,
  // I am skipping them in favor of performance now
  // but we should think another way to get them (from Lens embeddable or store)
  const performantQuery = {
    ...query
  };
  if ('esql' in performantQuery && performantQuery.esql) {
    performantQuery.esql = `${performantQuery.esql} | limit 0`;
  }
  const table = await (0, _textBasedEditor.fetchFieldsFromESQL)(performantQuery, deps.expressions, undefined, abortController);
  return table === null || table === void 0 ? void 0 : table.columns;
};
exports.getQueryColumns = getQueryColumns;
const getSuggestions = async (query, deps, datasourceMap, visualizationMap, adHocDataViews, setErrors, abortController) => {
  try {
    var _dataView$fields$getB, _suggestionsApi;
    let indexPattern = '';
    if ('sql' in query) {
      indexPattern = (0, _esqlUtils.getIndexPatternFromSQLQuery)(query.sql);
    }
    if ('esql' in query) {
      indexPattern = (0, _esqlUtils.getIndexPatternFromESQLQuery)(query.esql);
    }
    const dataViewSpec = adHocDataViews.find(adHoc => {
      return adHoc.name === indexPattern;
    });
    const dataView = dataViewSpec ? await deps.dataViews.create(dataViewSpec) : await (0, _esqlUtils.getESQLAdHocDataview)(indexPattern, deps.dataViews);
    if (((_dataView$fields$getB = dataView.fields.getByName('@timestamp')) === null || _dataView$fields$getB === void 0 ? void 0 : _dataView$fields$getB.type) === 'date' && !dataViewSpec) {
      dataView.timeFieldName = '@timestamp';
    }
    const columns = await getQueryColumns(query, deps, abortController);
    const context = {
      dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toSpec(),
      fieldName: '',
      textBasedColumns: columns,
      query
    };
    const allSuggestions = (_suggestionsApi = (0, _lens_suggestions_api.suggestionsApi)({
      context,
      dataView,
      datasourceMap,
      visualizationMap
    })) !== null && _suggestionsApi !== void 0 ? _suggestionsApi : [];

    // Lens might not return suggestions for some cases, i.e. in case of errors
    if (!allSuggestions.length) return undefined;
    const firstSuggestion = allSuggestions[0];
    const attrs = (0, _visualizationUtils.getLensAttributesFromSuggestion)({
      filters: [],
      query,
      suggestion: firstSuggestion,
      dataView
    });
    return attrs;
  } catch (e) {
    setErrors([e]);
  }
  return undefined;
};
exports.getSuggestions = getSuggestions;