"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEditLensConfiguration = getEditLensConfiguration;
exports.updatingMiddleware = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _react2 = require("@emotion/react");
var _public = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _state_management = require("../../../state_management");
var _id_generator = require("../../../id_generator");
var _lens_configuration_flyout = require("./lens_configuration_flyout");
var _persistence = require("../../../persistence");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function LoadingSpinnerWithOverlay() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null));
}
// exported for testing
const updatingMiddleware = updater => store => next => action => {
  const {
    datasourceStates: prevDatasourceStates,
    visualization: prevVisualization,
    activeDatasourceId: prevActiveDatasourceId
  } = store.getState().lens;
  next(action);
  const {
    datasourceStates,
    visualization,
    activeDatasourceId
  } = store.getState().lens;
  if (prevActiveDatasourceId !== activeDatasourceId || !(0, _lodash.isEqual)(prevDatasourceStates[prevActiveDatasourceId].state, datasourceStates[activeDatasourceId].state) || !(0, _lodash.isEqual)(prevVisualization, visualization)) {
    // ignore the actions that initialize the store with the state from the attributes
    if (_state_management.initExisting.match(action) || _state_management.initEmpty.match(action)) {
      return;
    }
    updater(datasourceStates[activeDatasourceId].state, visualization.state, visualization.activeId);
  }
};
exports.updatingMiddleware = updatingMiddleware;
async function getEditLensConfiguration(coreStart, startDependencies, visualizationMap, datasourceMap) {
  const {
    getLensServices,
    getLensAttributeService
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../../async_services')));
  const lensServices = await getLensServices(coreStart, startDependencies, getLensAttributeService(coreStart, startDependencies));
  return ({
    attributes,
    updatePanelState,
    updateSuggestion,
    closeFlyout,
    wrapInFlyout,
    datasourceId,
    panelId,
    savedObjectId,
    output$,
    lensAdapters,
    updateByRefInput,
    navigateToLensEditor,
    displayFlyoutHeader,
    canEditTextBasedQuery,
    isNewPanel,
    deletePanel,
    hidesSuggestions,
    onApplyCb,
    onCancelCb,
    hideTimeFilterInfo
  }) => {
    if (!lensServices || !datasourceMap || !visualizationMap) {
      return /*#__PURE__*/_react.default.createElement(LoadingSpinnerWithOverlay, null);
    }
    const [currentAttributes, setCurrentAttributes] = (0, _react.useState)(attributes);
    /**
     * During inline editing of a by reference panel, the panel is converted to a by value one.
     * When the user applies the changes we save them to the Lens SO
     */
    const saveByRef = (0, _react.useCallback)(async attrs => {
      const savedObjectStore = new _persistence.SavedObjectIndexStore(lensServices.contentManagement);
      await savedObjectStore.save({
        ...attrs,
        savedObjectId,
        type: _constants.DOC_TYPE
      });
    }, [savedObjectId]);
    const datasourceState = currentAttributes.state.datasourceStates[datasourceId];
    const storeDeps = {
      lensServices,
      datasourceMap,
      visualizationMap,
      initialContext: datasourceState && 'initialContext' in datasourceState ? datasourceState.initialContext : undefined
    };
    const lensStore = (0, _state_management.makeConfigureStore)(storeDeps, undefined, updatingMiddleware(updatePanelState));
    lensStore.dispatch((0, _state_management.loadInitial)({
      initialInput: {
        attributes: currentAttributes,
        id: panelId !== null && panelId !== void 0 ? panelId : (0, _id_generator.generateId)()
      },
      inlineEditing: true
    }));
    const getWrapper = children => {
      if (wrapInFlyout) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
          "data-test-subj": "lnsEditOnFlyFlyout",
          type: "push",
          ownFocus: true,
          paddingSize: "m",
          onClose: () => {
            closeFlyout === null || closeFlyout === void 0 ? void 0 : closeFlyout();
          },
          "aria-labelledby": _i18n.i18n.translate('xpack.lens.config.editLabel', {
            defaultMessage: 'Edit configuration'
          }),
          size: "s",
          hideCloseButton: true,
          css: (0, _react2.css)`
              clip-path: polygon(-100% 0, 100% 0, 100% 100%, -100% 100%);
            `
        }, children);
      } else {
        return children;
      }
    };
    const configPanelProps = {
      attributes: currentAttributes,
      updatePanelState,
      updateSuggestion,
      closeFlyout,
      datasourceId,
      coreStart,
      startDependencies,
      visualizationMap,
      output$,
      lensAdapters,
      datasourceMap,
      saveByRef,
      savedObjectId,
      updateByRefInput,
      navigateToLensEditor,
      displayFlyoutHeader,
      canEditTextBasedQuery,
      hidesSuggestions,
      setCurrentAttributes,
      isNewPanel,
      deletePanel,
      onApplyCb,
      onCancelCb,
      hideTimeFilterInfo
    };
    return getWrapper( /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
      store: lensStore
    }, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: coreStart.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: lensServices
    }, /*#__PURE__*/_react.default.createElement(_domDragDrop.RootDragDropProvider, null, /*#__PURE__*/_react.default.createElement(_lens_configuration_flyout.LensEditConfigurationFlyout, configPanelProps)))))));
  };
}