"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.redirectToDashboard = void 0;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const redirectToDashboard = ({
  embeddableInput,
  dashboardId,
  originatingApp,
  getOriginatingPath,
  stateTransfer
}) => {
  var _getOriginatingPath;
  const state = {
    input: embeddableInput,
    type: _constants.LENS_EMBEDDABLE_TYPE
  };
  const path = (_getOriginatingPath = getOriginatingPath === null || getOriginatingPath === void 0 ? void 0 : getOriginatingPath(dashboardId)) !== null && _getOriginatingPath !== void 0 ? _getOriginatingPath : dashboardId === 'new' ? '#/create' : `#/view/${dashboardId}`;
  const appId = originatingApp || 'dashboards';
  stateTransfer.navigateToWithEmbeddablePackage(appId, {
    state,
    path
  });
};
exports.redirectToDashboard = redirectToDashboard;