"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.redirectWhenMissing = redirectWhenMissing;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _theme = require("../theme");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const ReactMarkdown = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('react-markdown'))));
const ErrorRenderer = props => /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
}, /*#__PURE__*/_react.default.createElement(ReactMarkdown, props));
function addNotFoundToPath(path, error) {
  return path + (path.indexOf('?') >= 0 ? '&' : '?') + `notFound=${error.savedObjectType}&notFoundMessage=${error.message}`;
}

/**
 * Creates an error handler that will redirect to a url when a SavedObjectNotFound
 * error is thrown
 */
function redirectWhenMissing({
  history,
  navigateToApp,
  basePath,
  mapping,
  toastNotifications,
  onBeforeRedirect,
  theme
}) {
  let localMappingObject;
  if (typeof mapping === 'string') {
    localMappingObject = {
      '*': mapping
    };
  } else {
    localMappingObject = mapping;
  }
  return error => {
    // if this error is not "404", rethrow
    // we can't check "error instanceof SavedObjectNotFound" since this class can live in a separate bundle
    // and the error will be an instance of other class with the same interface (actually the copy of SavedObjectNotFound class)
    if (!error.savedObjectType) {
      throw error;
    }
    let redirectTarget = localMappingObject[error.savedObjectType] || localMappingObject['*'] || '/';
    if (typeof redirectTarget !== 'string') {
      redirectTarget.path = addNotFoundToPath(redirectTarget.path, error);
    } else {
      redirectTarget = addNotFoundToPath(redirectTarget, error);
    }
    toastNotifications.addWarning({
      title: _i18n.i18n.translate('kibana_utils.history.savedObjectIsMissingNotificationMessage', {
        defaultMessage: 'Saved object is missing'
      }),
      text: element => {
        _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_theme.KibanaThemeProvider, {
          theme$: theme.theme$
        }, /*#__PURE__*/_react.default.createElement(ErrorRenderer, null, error.message)), element);
        return () => _reactDom.default.unmountComponentAtNode(element);
      }
    });
    if (onBeforeRedirect) {
      onBeforeRedirect(error);
    }
    if (typeof redirectTarget !== 'string') {
      if (redirectTarget.app === 'kibana') {
        // exception for kibana app because redirect won't work right otherwise
        window.location.href = basePath.prepend(`/app/kibana${redirectTarget.path}`);
      } else {
        navigateToApp(redirectTarget.app, {
          path: redirectTarget.path
        });
      }
    } else {
      history.replace(redirectTarget);
    }
  };
}