"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InteractiveSetupPlugin = void 0;
var _chalk = _interopRequireDefault(require("chalk"));
var _securityHardening = require("@kbn/security-hardening");
var _utils = require("@kbn/utils");
var _elasticsearch_service = require("./elasticsearch_service");
var _kibana_config_writer = require("./kibana_config_writer");
var _routes = require("./routes");
var _verification_service = require("./verification_service");
var _common = require("../common");
function _classPrivateFieldInitSpec(obj, privateMap, value) { _checkPrivateRedeclaration(obj, privateMap); privateMap.set(obj, value); }
function _checkPrivateRedeclaration(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// List of the Elasticsearch hosts Kibana uses by default.
const DEFAULT_ELASTICSEARCH_HOSTS = ['http://localhost:9200',
// It's a default host we use in the official Kibana Docker image (see `kibana_yml.template.ts`).
...(process.env.ELASTIC_CONTAINER ? ['http://elasticsearch:9200'] : [])];
var _logger = /*#__PURE__*/new WeakMap();
var _elasticsearch = /*#__PURE__*/new WeakMap();
var _verification = /*#__PURE__*/new WeakMap();
var _elasticsearchConnectionStatusSubscription = /*#__PURE__*/new WeakMap();
var _configSubscription = /*#__PURE__*/new WeakMap();
var _config = /*#__PURE__*/new WeakMap();
var _getConfig = /*#__PURE__*/new WeakMap();
class InteractiveSetupPlugin {
  constructor(initializerContext) {
    _classPrivateFieldInitSpec(this, _logger, void 0);
    _classPrivateFieldInitSpec(this, _elasticsearch, void 0);
    _classPrivateFieldInitSpec(this, _verification, void 0);
    _classPrivateFieldInitSpec(this, _elasticsearchConnectionStatusSubscription, void 0);
    _classPrivateFieldInitSpec(this, _configSubscription, void 0);
    _classPrivateFieldInitSpec(this, _config, void 0);
    _classPrivateFieldInitSpec(this, _getConfig, () => {
      if (!_classPrivateFieldGet(_config, this)) {
        throw new Error('Config is not available.');
      }
      return _classPrivateFieldGet(_config, this);
    });
    this.initializerContext = initializerContext;
    _classPrivateFieldSet(_logger, this, this.initializerContext.logger.get());
    _classPrivateFieldSet(_elasticsearch, this, new _elasticsearch_service.ElasticsearchService(this.initializerContext.logger.get('elasticsearch'), initializerContext.env.packageInfo.version));
    _classPrivateFieldSet(_verification, this, new _verification_service.VerificationService(this.initializerContext.logger.get('verification')));
  }
  setup(core) {
    var _this$initializerCont;
    _classPrivateFieldSet(_configSubscription, this, this.initializerContext.config.create().subscribe(config => {
      _classPrivateFieldSet(_config, this, config);
    }));

    // We shouldn't activate interactive setup mode if we detect that user has already configured
    // Elasticsearch connection manually: either if Kibana system user credentials are specified or
    // user specified non-default host for the Elasticsearch.
    const shouldActiveSetupMode = !core.elasticsearch.config.credentialsSpecified && core.elasticsearch.config.hosts.length === 1 && DEFAULT_ELASTICSEARCH_HOSTS.includes(core.elasticsearch.config.hosts[0]);
    if (!shouldActiveSetupMode) {
      const reason = core.elasticsearch.config.credentialsSpecified ? 'Kibana system user credentials are specified' : core.elasticsearch.config.hosts.length > 1 ? 'more than one Elasticsearch host is specified' : 'non-default Elasticsearch host is used';
      _classPrivateFieldGet(_logger, this).debug(`Interactive setup mode will not be activated since Elasticsearch connection is already configured: ${reason}.`);
      return;
    }
    const verificationCode = _classPrivateFieldGet(_verification, this).setup();
    if (!verificationCode) {
      _classPrivateFieldGet(_logger, this).error('Interactive setup mode could not be activated. Ensure Kibana has permission to write to its config folder.');
      return;
    }
    let completeSetup;
    core.preboot.holdSetupUntilResolved('Validating Elasticsearch connection configuration…', new Promise(resolve => {
      completeSetup = resolve;
    }));

    // If preliminary checks above indicate that user didn't alter default Elasticsearch connection
    // details, it doesn't mean Elasticsearch connection isn't configured. There is a chance that
    // user has already disabled security features in Elasticsearch and everything should work by
    // default. We should check if we can connect to Elasticsearch with default configuration to
    // know if we need to activate interactive setup. This check can take some time, so we should
    // register our routes to let interactive setup UI to handle user requests until the check is
    // complete. Moreover Elasticsearch may be just temporarily unavailable and we should poll its
    // status until we can connect or use configures connection via interactive setup mode.
    const elasticsearch = _classPrivateFieldGet(_elasticsearch, this).setup({
      elasticsearch: core.elasticsearch,
      connectionCheckInterval: _classPrivateFieldGet(_getConfig, this).call(this).connectionCheck.interval
    });
    _classPrivateFieldSet(_elasticsearchConnectionStatusSubscription, this, elasticsearch.connectionStatus$.subscribe(status => {
      if (status === _common.ElasticsearchConnectionStatus.Configured) {
        _classPrivateFieldGet(_logger, this).debug('Skipping interactive setup mode since Kibana is already properly configured to connect to Elasticsearch at http://localhost:9200.');
        completeSetup({
          shouldReloadConfig: false
        });
      } else {
        _classPrivateFieldGet(_logger, this).debug('Starting interactive setup mode since Kibana cannot to connect to Elasticsearch at http://localhost:9200.');
        const pathname = core.http.basePath.prepend('/');
        const {
          protocol,
          hostname,
          port
        } = core.http.getServerInfo();
        const url = `${protocol}://${hostname}:${port}${pathname}?code=${verificationCode.code}`;

        // eslint-disable-next-line @kbn/eslint/no_unsafe_console
        _securityHardening.unsafeConsole.log(`

${_chalk.default.whiteBright.bold(`${_chalk.default.cyanBright('i')} Kibana has not been configured.`)}

Go to ${_chalk.default.cyanBright.underline(url)} to get started.

`);
      }
    }));

    // If possible, try to use `*.dev.yml` config when Kibana is run in development mode.
    const configPath = this.initializerContext.env.mode.dev ? (_this$initializerCont = this.initializerContext.env.configs.find(config => config.endsWith('.dev.yml'))) !== null && _this$initializerCont !== void 0 ? _this$initializerCont : this.initializerContext.env.configs[0] : this.initializerContext.env.configs[0];
    core.http.registerRoutes('', router => {
      (0, _routes.defineRoutes)({
        router,
        basePath: core.http.basePath,
        logger: _classPrivateFieldGet(_logger, this).get('routes'),
        preboot: {
          ...core.preboot,
          completeSetup
        },
        kibanaConfigWriter: new _kibana_config_writer.KibanaConfigWriter(configPath, (0, _utils.getDataPath)(), _classPrivateFieldGet(_logger, this).get('kibana-config')),
        elasticsearch,
        verificationCode,
        getConfig: _classPrivateFieldGet(_getConfig, this).bind(this)
      });
    });
  }
  stop() {
    _classPrivateFieldGet(_logger, this).debug('Stopping plugin');
    if (_classPrivateFieldGet(_configSubscription, this)) {
      _classPrivateFieldGet(_configSubscription, this).unsubscribe();
      _classPrivateFieldSet(_configSubscription, this, undefined);
    }
    if (_classPrivateFieldGet(_elasticsearchConnectionStatusSubscription, this)) {
      _classPrivateFieldGet(_elasticsearchConnectionStatusSubscription, this).unsubscribe();
      _classPrivateFieldSet(_elasticsearchConnectionStatusSubscription, this, undefined);
    }
    _classPrivateFieldGet(_elasticsearch, this).stop();
    _classPrivateFieldGet(_verification, this).stop();
  }
}
exports.InteractiveSetupPlugin = InteractiveSetupPlugin;