"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestCodeViewer = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _react = _interopRequireDefault(require("react"));
var _codeEditor = require("@kbn/code-editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// We want to allow both right-clicking to open in a new tab and clicking through
// the "Open in Console" link. We could use `RedirectAppLinks` at the top level
// but that inserts a div which messes up the layout of the inspector.

const copyToClipboardLabel = _i18n.i18n.translate('inspector.requests.copyToClipboardLabel', {
  defaultMessage: 'Copy to clipboard'
});

/**
 * @internal
 */
const RequestCodeViewer = ({
  value,
  actions
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    wrap: false,
    responsive: false,
    className: "insRequestCodeViewer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "m",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: value
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    iconType: "copyClipboard",
    onClick: copy,
    "data-test-subj": "inspectorRequestCopyClipboardButton"
  }, copyToClipboardLabel)))), !!actions && actions.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: item.name
  }, /*#__PURE__*/_react.default.createElement("div", null, item.action))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    "data-test-subj": "inspectorRequestCodeViewerContainer"
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: _monaco.XJsonLang.ID,
    value: value,
    options: {
      readOnly: true,
      lineNumbers: 'off',
      fontSize: 12,
      minimap: {
        enabled: false
      },
      folding: true,
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true
    }
  })));
};
exports.RequestCodeViewer = RequestCodeViewer;