"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deprecatedPipelineBadge = exports.PipelineTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../shared_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deprecatedPipelineBadge = exports.deprecatedPipelineBadge = {
  badge: _i18n.i18n.translate('xpack.ingestPipelines.list.table.deprecatedBadgeLabel', {
    defaultMessage: 'Deprecated'
  }),
  badgeTooltip: _i18n.i18n.translate('xpack.ingestPipelines.list.table.deprecatedBadgeTooltip', {
    defaultMessage: 'This pipeline is no longer supported and might be removed in a future release. Instead, use one of the other pipelines available or create a new one.'
  })
};
const deprecatedFilterLabel = _i18n.i18n.translate('xpack.ingestPipelines.list.table.deprecatedFilterLabel', {
  defaultMessage: 'Deprecated'
});
const managedFilterLabel = _i18n.i18n.translate('xpack.ingestPipelines.list.table.managedFilterLabel', {
  defaultMessage: 'Managed'
});
const PipelineTable = ({
  pipelines,
  isLoading,
  onReloadClick,
  onEditPipelineClick,
  onClonePipelineClick,
  onDeletePipelineClick
}) => {
  const [filterOptions, setFilterOptions] = (0, _react.useState)([{
    key: 'managed',
    label: managedFilterLabel
  }, {
    key: 'deprecated',
    label: deprecatedFilterLabel,
    checked: 'off'
  }]);
  const {
    history
  } = (0, _shared_imports.useKibana)().services;
  const [selection, setSelection] = (0, _react.useState)([]);
  const filteredPipelines = (0, _react.useMemo)(() => {
    return (pipelines || []).filter(pipeline => {
      var _filterOptions$find, _filterOptions$find2;
      const deprecatedFilter = (_filterOptions$find = filterOptions.find(({
        key
      }) => key === 'deprecated')) === null || _filterOptions$find === void 0 ? void 0 : _filterOptions$find.checked;
      const managedFilter = (_filterOptions$find2 = filterOptions.find(({
        key
      }) => key === 'managed')) === null || _filterOptions$find2 === void 0 ? void 0 : _filterOptions$find2.checked;
      return !(deprecatedFilter === 'off' && pipeline.deprecated || deprecatedFilter === 'on' && !pipeline.deprecated || managedFilter === 'off' && pipeline.isManaged || managedFilter === 'on' && !pipeline.isManaged);
    });
  }, [pipelines, filterOptions]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    badgeColor: "success",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: filterOptions.filter(item => item.checked !== 'off').length,
    hasActiveFilters: !!filterOptions.find(item => item.checked === 'on'),
    numActiveFilters: filterOptions.filter(item => item.checked === 'on').length
  }, _i18n.i18n.translate('xpack.ingestPipelines.list.table.filtersButtonLabel', {
    defaultMessage: 'Filters'
  }));
  const tableProps = {
    itemId: 'name',
    isSelectable: true,
    'data-test-subj': 'pipelinesTable',
    sorting: {
      sort: {
        field: 'name',
        direction: 'asc'
      }
    },
    selection: {
      onSelectionChange: setSelection
    },
    rowProps: () => ({
      'data-test-subj': 'pipelineTableRow'
    }),
    cellProps: (pipeline, column) => {
      const {
        field
      } = column;
      return {
        'data-test-subj': `pipelineTableRow-${field}`
      };
    },
    search: {
      toolsLeft: selection.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "deletePipelinesButton",
        onClick: () => onDeletePipelineClick(selection.map(pipeline => pipeline.name)),
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.table.deletePipelinesButtonLabel",
        defaultMessage: "Delete {count, plural, one {pipeline} other {pipelines} }",
        values: {
          count: selection.length
        }
      })) : undefined,
      toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        key: "reloadButton",
        iconType: "refresh",
        color: "success",
        "aria-label": "refresh button",
        "data-test-subj": "reloadButton",
        size: "m",
        display: "base",
        onClick: onReloadClick
      })],
      box: {
        incremental: true,
        'data-test-subj': 'pipelineTableSearch'
      },
      filters: [{
        type: 'custom_component',
        component: () => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
            id: "popoverID",
            button: button,
            isOpen: isPopoverOpen,
            closePopover: closePopover,
            panelPaddingSize: "none"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
            allowExclusions: true,
            "aria-label": _i18n.i18n.translate('xpack.ingestPipelines.list.table.filtersAriaLabel', {
              defaultMessage: 'Filters'
            }),
            options: filterOptions,
            onChange: setFilterOptions
          }, list => /*#__PURE__*/_react.default.createElement("div", {
            style: {
              width: 300
            }
          }, list))));
        }
      }]
    },
    pagination: {
      initialPageSize: 10,
      pageSizeOptions: [10, 20, 50]
    },
    columns: [{
      width: '25%',
      field: 'name',
      name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.nameColumnTitle', {
        defaultMessage: 'Name'
      }),
      sortable: true,
      render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        "data-test-subj": "pipelineDetailsLink"
      }, (0, _public.reactRouterNavigate)(history, {
        pathname: '/',
        search: `pipeline=${encodeURIComponent(name)}`
      })), name)
    }, {
      width: '100px',
      render: pipeline => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          direction: "column",
          gutterSize: "xs",
          alignItems: "center"
        }, pipeline.isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          "data-test-subj": "isManagedBadge"
        }, _i18n.i18n.translate('xpack.ingestPipelines.list.table.managedBadgeLabel', {
          defaultMessage: 'Managed'
        }))), pipeline.deprecated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: deprecatedPipelineBadge.badgeTooltip
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "warning",
          "data-test-subj": "isDeprecatedBadge"
        }, deprecatedPipelineBadge.badge))));
      }
    }, {
      field: 'description',
      sortable: true,
      name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.descriptionColumnTitle', {
        defaultMessage: 'Description'
      })
    }, {
      width: '120px',
      name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.preprocessorsColumnTitle', {
        defaultMessage: 'Preprocessors'
      }),
      align: 'right',
      dataType: 'number',
      sortable: ({
        processors
      }) => processors.length,
      render: ({
        processors
      }) => processors.length
    }, {
      width: '120px',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.table.actionColumnTitle",
        defaultMessage: "Actions"
      }),
      actions: [{
        isPrimary: true,
        name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.editActionLabel', {
          defaultMessage: 'Edit'
        }),
        description: _i18n.i18n.translate('xpack.ingestPipelines.list.table.editActionDescription', {
          defaultMessage: 'Edit this pipeline'
        }),
        type: 'icon',
        icon: 'pencil',
        onClick: ({
          name
        }) => onEditPipelineClick(name)
      }, {
        name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.cloneActionLabel', {
          defaultMessage: 'Clone'
        }),
        description: _i18n.i18n.translate('xpack.ingestPipelines.list.table.cloneActionDescription', {
          defaultMessage: 'Clone this pipeline'
        }),
        type: 'icon',
        icon: 'copy',
        onClick: ({
          name
        }) => onClonePipelineClick(name)
      }, {
        isPrimary: true,
        name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.deleteActionLabel', {
          defaultMessage: 'Delete'
        }),
        description: _i18n.i18n.translate('xpack.ingestPipelines.list.table.deleteActionDescription', {
          defaultMessage: 'Delete this pipeline'
        }),
        type: 'icon',
        icon: 'trash',
        color: 'danger',
        onClick: ({
          name
        }) => onDeletePipelineClick([name])
      }]
    }],
    items: filteredPipelines,
    loading: isLoading
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, tableProps);
};
exports.PipelineTable = PipelineTable;